/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.jobconductor;

public enum TRIGGER_TYPE {
    SIMPLE_TRIGGER("SimpleTrigger", true, TRIGGER_TYPE.getEmptyString()),
    CRON_TRIGGER("CronTrigger", true, TRIGGER_TYPE.getEmptyString()),
    CRON_UI_TRIGGER("CronUITrigger", true, TRIGGER_TYPE.getEmptyString()),
    FILE_TRIGGER("FileTrigger", false, TRIGGER_TYPE.getFileTriggerPrefix());

    private static final String EMPTY_STRING = "";
    private static final String TIME_TRIGGER_PREFIX = "";
    private static final String FILE_TRIGGER_PREFIX = "FileTrigger";
    private static final String FILE_TRIGGER_PARENT_PREFIX = "FileTriggerJob";
    private String triggerType;
    private boolean timeTrigger;
    private String prefix;

    private TRIGGER_TYPE(String mappingForward, boolean timeTrigger) {
        this.triggerType = mappingForward;
        this.timeTrigger = timeTrigger;
    }

    private TRIGGER_TYPE(String mappingForward, boolean timeTrigger, String prefix) {
        this(mappingForward, timeTrigger);
        this.prefix = prefix;
    }

    public String getTriggerTypeStr() {
        return this.triggerType;
    }

    public static TRIGGER_TYPE get(String triggerTypeStr) {
        TRIGGER_TYPE[] values = TRIGGER_TYPE.values();
        int i = 0;
        while (i < values.length) {
            TRIGGER_TYPE triggerTypeCurrent = values[i];
            if (triggerTypeCurrent.triggerType.equals(triggerTypeStr)) {
                return triggerTypeCurrent;
            }
            ++i;
        }
        return null;
    }

    public boolean isTimeTrigger() {
        return this.timeTrigger;
    }

    public boolean isFileTrigger() {
        return !this.timeTrigger;
    }

    public String getPrefix() {
        return this.prefix;
    }

    private static String getEmptyString() {
        return "";
    }

    public static String getFileTriggerPrefix() {
        return FILE_TRIGGER_PREFIX;
    }

    public static String getFileTriggerParentPrefix() {
        return FILE_TRIGGER_PARENT_PREFIX;
    }

    public static String getTimeTriggerPrefix() {
        return "";
    }
}

