/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils;

import java.io.File;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.utils.JavaVersion;

public class StudioKeysFileCheck {
    public static final String ENCRYPTION_KEY_FILE_SYS_PROP = "encryption.keys.file";
    public static final String ENCRYPTION_KEY_FILE_JVM_PARAM = "-Dencryption.keys.file";
    public static final String ENCRYPTION_KEY_FILE_NAME = "studio.keys";
    private static final Logger LOGGER = LoggerFactory.getLogger(StudioKeysFileCheck.class);
    private static final String JAVA_VERSION_PROP = "java.version";
    public static final String JAVA_VERSION_MINIMAL_STRING = "1.8.0_161";
    private static final JavaVersion JAVA_VERSION_MINIMAL = new JavaVersion("1.8.0_161");

    private StudioKeysFileCheck() {
    }

    public static void check(File confDir) {
        if (confDir == null) {
            IllegalArgumentException e = new IllegalArgumentException("Encryption keys file path invalid");
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        String keyFile = System.getProperty(ENCRYPTION_KEY_FILE_SYS_PROP);
        if (keyFile == null || keyFile.isEmpty() || !new File(keyFile).exists()) {
            keyFile = Paths.get(confDir.getAbsolutePath(), ENCRYPTION_KEY_FILE_NAME).toString();
            System.setProperty(ENCRYPTION_KEY_FILE_SYS_PROP, keyFile);
        }
        LOGGER.info("encryptionKeyFilePath: " + keyFile);
    }

    public static void validateJavaVersion() {
        String currentVersion = StudioKeysFileCheck.getJavaVersion();
        JavaVersion cv = new JavaVersion(currentVersion);
        if (cv.compareTo(JAVA_VERSION_MINIMAL) < 0) {
            RuntimeException e = new RuntimeException("Java upgrade required, minimal required java version is 1.8.0_161, current version is " + currentVersion);
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static String getJavaVersion() {
        return System.getProperty(JAVA_VERSION_PROP);
    }
}

