/*
 * Decompiled with CFR 0.152.
 */
package org.talend.jobbuilder.model;

public enum EPlatform {
    Windows("Windows", "win32", "win32", "x86_64"),
    Linux("Linux", "linux", "gtk", "x86_64"),
    Mac_OS_X("Mac OS X", "macosx", "cocoa", "x86_64");

    private String desc;
    private String os;
    private String ws;
    private String arch;

    private EPlatform(String desc, String os, String ws, String arch) {
        this.desc = desc;
        this.os = os;
        this.ws = ws;
        this.arch = arch;
    }

    public static EPlatform getPlatformInfo(String os) {
        if (os == null) {
            String osName = System.getProperty("os.name");
            if (osName.startsWith(EPlatform.Windows.desc)) {
                return Windows;
            }
            return Linux;
        }
        for (EPlatform platform : EPlatform.values()) {
            if (!platform.os.equals(os)) continue;
            return platform;
        }
        return null;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getOs() {
        return this.os;
    }

    public String getWs() {
        return this.ws;
    }

    public String getArch() {
        return this.arch;
    }
}

