/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commons.utils.threading.lockerbykey;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.commons.utils.StringUtils;
import org.talend.commons.utils.threading.lockerbykey.CustomReentrantLock;
import org.talend.commons.utils.threading.lockerbykey.ILockerByKey;
import org.talend.commons.utils.threading.lockerbykey.LockerValue;
import org.talend.commons.utils.threading.lockerbykey.LockerValueHandler;

public class LockerByKey<KP>
implements ILockerByKey<KP> {
    private static Logger log = LoggerFactory.getLogger(LockerByKey.class);
    private ConcurrentHashMap<InternalKeyLock<KP>, LockerValue<KP>> mapKeyLockToValueLock = new ConcurrentHashMap();
    private final Object lockAllOperations = new Object();
    private AtomicInteger counter = new AtomicInteger();
    private AtomicInteger runningOperations = new AtomicInteger();
    private static final int DEFAULT_CLEAN_PERIOD = 500;
    private static final boolean DEFAULT_FAIR = true;
    private int cleanPeriod;
    private boolean fair;
    private volatile boolean blockAllOperations;
    private volatile boolean shuttingDown;
    private volatile boolean stopped;
    private static boolean detectSuspectLocksStatic = false;
    private boolean detectSuspectLocks = false;
    private boolean forceShutdown;

    public LockerByKey() {
        this(true, 500);
    }

    public LockerByKey(boolean fair) {
        this(fair, 500);
    }

    public LockerByKey(int cleanPeriod) {
        this(true, cleanPeriod);
    }

    public LockerByKey(boolean fair, int cleanPeriod) {
        this.fair = fair;
        if (cleanPeriod <= 0) {
            throw new IllegalArgumentException("The cleanPeriod value has to be greater than 0");
        }
        this.cleanPeriod = cleanPeriod;
        this.detectSuspectLocks = detectSuspectLocksStatic;
        if (this.detectSuspectLocks) {
            this.launchThreadDebugger();
        }
    }

    protected LockerByKey(boolean fair, boolean cleanDisabled) {
        this.fair = fair;
        this.cleanPeriod = cleanDisabled ? 0 : 500;
        this.detectSuspectLocks = detectSuspectLocksStatic;
        if (this.detectSuspectLocks) {
            this.launchThreadDebugger();
        }
    }

    private void launchThreadDebugger() {
        new Thread(this.getClass().getSimpleName() + "-ThreadDebugger-" + this.hashCode()){

            @Override
            public void run() {
                while (!LockerByKey.this.stopped && !LockerByKey.this.shuttingDown) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    long timeDetectionLimitMs = 30000L;
                    List lockerValues = LockerByKey.this.getSuspectLocks(timeDetectionLimitMs);
                    StringBuilder sb = new StringBuilder();
                    for (LockerValue lockerValue : lockerValues) {
                        StackTraceElement[] stackTraceOfLocker;
                        long duration = System.currentTimeMillis() - lockerValue.getLockedTime();
                        StackTraceElement[] stackTraceElementArray = stackTraceOfLocker = lockerValue.getStackTraceOfLocker();
                        int n = stackTraceElementArray.length;
                        for (int i = 0; i < n; ++i) {
                            StackTraceElement trace;
                            StackTraceElement stackTraceElement = trace = stackTraceElementArray[i];
                            sb.append(stackTraceElement.toString());
                            sb.append("\n");
                        }
                        log.warn("Suspect lock done since " + duration + " ms by: " + sb.toString());
                    }
                }
            }
        }.start();
    }

    @Override
    public boolean isLocked(KP key) {
        this.checkKey(key);
        LockerValue<KP> locker = this.getLockerValue(key);
        return locker != null && locker.getLock().isLocked();
    }

    @Override
    public void lockInterruptibly(KP key) throws InterruptedException {
        LockerValue<KP> lockerValue;
        this.checkStopped();
        this.checkKey(key);
        this.blockOperationIfRequired();
        this.incrementRunningOperations();
        try {
            lockerValue = this.prepareInternalLock(key);
        }
        finally {
            this.decrementRunningOperations();
        }
        lockerValue.getLock().lockInterruptibly();
        this.traceStackForDebugging(lockerValue);
    }

    @Override
    public boolean tryLock(KP key) {
        LockerValue<KP> lockerValue;
        if (this.stopped || this.shuttingDown) {
            return false;
        }
        this.checkKey(key);
        this.blockOperationIfRequired();
        this.incrementRunningOperations();
        try {
            lockerValue = this.prepareInternalLock(key);
        }
        finally {
            this.decrementRunningOperations();
        }
        boolean locked = lockerValue.getLock().tryLock();
        if (locked) {
            this.traceStackForDebugging(lockerValue);
        }
        return locked;
    }

    @Override
    public boolean tryLock(KP key, long timeout) throws InterruptedException {
        return this.tryLock(key, timeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock(KP key, long timeout, TimeUnit unit) throws InterruptedException {
        LockerValue<KP> lockerValue;
        this.checkStopped();
        this.checkKey(key);
        this.blockOperationIfRequired();
        this.incrementRunningOperations();
        try {
            lockerValue = this.prepareInternalLock(key);
        }
        finally {
            this.decrementRunningOperations();
        }
        this.interruptIfStopping();
        boolean locked = lockerValue.getLock().tryLock(timeout, unit);
        if (locked) {
            this.traceStackForDebugging(lockerValue);
        }
        return locked;
    }

    private LockerValue<KP> prepareInternalLock(KP key) {
        InternalKeyLock<KP> internalKeyLock = new InternalKeyLock<KP>(key);
        LockerValue<KP> lockerValue = new LockerValue<KP>(key, this.fair);
        LockerValue<KP> previousLockerValue = null;
        previousLockerValue = this.mapKeyLockToValueLock.putIfAbsent(internalKeyLock, lockerValue);
        if (previousLockerValue != null) {
            lockerValue = previousLockerValue;
        }
        return lockerValue;
    }

    private void interruptIfStopping() throws InterruptedException {
        if (this.shuttingDown) {
            throw new InterruptedException("This LockerByKey is shutting down...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unlock(KP key) {
        boolean returnValue;
        this.checkKey(key);
        this.blockOperationIfRequired();
        this.incrementRunningOperations();
        LockerValue<KP> lockerValue = this.getLockerValue(key);
        try {
            returnValue = false;
            if (lockerValue != null) {
                lockerValue.getLock().unlock();
                returnValue = true;
            }
        }
        finally {
            this.decrementRunningOperations();
        }
        this.cleanAccordingOperations();
        return returnValue;
    }

    void traceStackForDebugging(LockerValue<KP> lockerValue) {
        if (this.detectSuspectLocks) {
            lockerValue.setStackTraceOfLocker(Thread.currentThread().getStackTrace());
            lockerValue.setLockedTime(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanAccordingOperations() {
        Object object = this.lockAllOperations;
        synchronized (object) {
            if (this.cleanPeriod > 0 && this.counter.incrementAndGet() % this.cleanPeriod == 0) {
                this.clean();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clean() {
        Object object = this.lockAllOperations;
        synchronized (object) {
            this.blockAllOperations();
            if (!this.forceShutdown || !this.shuttingDown) {
                this.waitForRunningOperationsEnded();
            }
            Collection<LockerValue<KP>> values = this.mapKeyLockToValueLock.values();
            if (log.isTraceEnabled()) {
                log.trace("Cleaning " + this.toString() + " : " + values.size() + " keys/values ...");
            }
            InternalKeyLock<KP> internalKeyLock = new InternalKeyLock<KP>();
            for (LockerValue<KP> lockerValue : values) {
                CustomReentrantLock lock = lockerValue.getLock();
                LockerValueHandler handler = lockerValue.getHandler();
                if (lock.hasQueuedThreads() || lock.isLocked() || handler != null) continue;
                internalKeyLock.setKey(lockerValue.getKey());
                this.mapKeyLockToValueLock.remove(internalKeyLock);
            }
            this.resumeAllOperations();
        }
    }

    private void checkStopped() {
        if (this.stopped || this.shuttingDown) {
            throw new IllegalStateException("This locker is already stopped or is shutting down !");
        }
    }

    private void checkKey(KP key) {
        if (key == null) {
            throw new IllegalArgumentException("key can't be null");
        }
    }

    private void waitForRunningOperationsEnded() {
        while (this.runningOperations.get() > 0) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    private void resumeAllOperations() {
        this.blockAllOperations = false;
        this.lockAllOperations.notifyAll();
    }

    private void blockAllOperations() {
        this.blockAllOperations = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockOperationIfRequired() {
        if (this.blockAllOperations) {
            Object object = this.lockAllOperations;
            synchronized (object) {
                if (this.blockAllOperations) {
                    try {
                        this.lockAllOperations.wait();
                    }
                    catch (InterruptedException e) {
                        log.warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    private void decrementRunningOperations() {
        this.runningOperations.decrementAndGet();
    }

    private void incrementRunningOperations() {
        this.runningOperations.incrementAndGet();
    }

    @Override
    public LockerValue<KP> getLockerValue(KP key) {
        this.checkKey(key);
        InternalKeyLock<KP> internalKeyLock = new InternalKeyLock<KP>(key);
        return this.mapKeyLockToValueLock.get(internalKeyLock);
    }

    @Override
    public synchronized void shutdownNow() {
        this.forceShutdown = true;
        this.shutdown();
    }

    @Override
    public synchronized void shutdown() {
        this.shuttingDown = true;
        this.blockAllOperations();
        if (!this.forceShutdown) {
            this.waitForRunningOperationsEnded();
        }
        Collection<LockerValue<KP>> values = this.mapKeyLockToValueLock.values();
        for (LockerValue<KP> lockerValue : values) {
            Collection<Thread> queuedThreads = lockerValue.getLock().getQueuedThreads();
            for (Thread thread : queuedThreads) {
                thread.interrupt();
            }
        }
        this.clean();
        this.stopped = true;
    }

    public String toString() {
        return "LockerByKey:" + super.toString();
    }

    @Override
    public int getCleanPeriod() {
        return this.cleanPeriod;
    }

    @Override
    public boolean isDetectSuspectLocks() {
        return this.detectSuspectLocks;
    }

    @Override
    public void setDetectSuspectLocks(boolean detectSuspectLocks) {
        this.detectSuspectLocks = detectSuspectLocks;
    }

    @Override
    public List<LockerValue<KP>> getSuspectLocks(long timeDetectionLimitMs) {
        if (this.detectSuspectLocks) {
            Collection<LockerValue<KP>> values = this.mapKeyLockToValueLock.values();
            ArrayList<LockerValue<KP>> stacks = new ArrayList<LockerValue<KP>>();
            for (LockerValue<KP> lockerValue : values) {
                long lockedTime = lockerValue.getLockedTime();
                long duration = System.currentTimeMillis() - lockedTime;
                if (lockedTime <= 0L || duration <= timeDetectionLimitMs || !lockerValue.getLock().isLocked()) continue;
                stacks.add(lockerValue);
            }
            return stacks;
        }
        throw new UnsupportedOperationException("You have to enable the 'detectSuspectLocks' mode by using the JVM argument -DdetectSuspectLocks=true");
    }

    Map<InternalKeyLock<KP>, LockerValue<KP>> getMapKeyLockToValueLock() {
        return new HashMap<InternalKeyLock<KP>, LockerValue<KP>>(this.mapKeyLockToValueLock);
    }

    static {
        String optionKey = "detectSuspectLocks";
        String detectSuspectLocksStr = System.getProperty(optionKey);
        if (detectSuspectLocksStr != null && detectSuspectLocksStr.length() > 0) {
            detectSuspectLocksStatic = Boolean.parseBoolean(detectSuspectLocksStr);
        }
        if (detectSuspectLocksStatic) {
            log.info("System property \"" + optionKey + "\"=" + detectSuspectLocksStatic);
        }
    }

    class InternalKeyLock<IKP> {
        private IKP key;

        public InternalKeyLock() {
        }

        public InternalKeyLock(IKP key) {
            this.key = key;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InternalKeyLock other = (InternalKeyLock)obj;
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }

        public void setKey(IKP key) {
            this.key = key;
        }

        public String toString() {
            return StringUtils.replacePrms(InternalKeyLock.class.getSimpleName() + ": key={0}", this.key);
        }
    }
}

