/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commons.utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final String OPEN_BRACE = "{";
    private static final String CLOSE_BRACE = "}";
    private static final StringDigitComparator STR_DIGIT_COMPARATOR = new StringDigitComparator();

    public static String repeat(String str, int repeat) {
        return org.apache.commons.lang3.StringUtils.repeat((String)str, (int)repeat);
    }

    public static String join(Object[] array, String separator) {
        return org.apache.commons.lang3.StringUtils.join((Object[])array, (String)separator);
    }

    public static String[] split(String string, char separator) {
        return org.apache.commons.lang3.StringUtils.split((String)string, (char)separator);
    }

    public static String replace(String text, String repl, String with) {
        return org.apache.commons.lang3.StringUtils.replace((String)text, (String)repl, (String)with);
    }

    public static List<String> splitAsList(String string, char separator) {
        String[] strings = org.apache.commons.lang3.StringUtils.split((String)string, (char)separator);
        return Arrays.asList(strings);
    }

    public static String capitalize(String str) {
        return org.apache.commons.lang3.StringUtils.capitalize((String)str);
    }

    public static String getMysqlProtectedColumnName(String colname) {
        return "`" + colname + "`";
    }

    public static String getPostgresqlProtectedColumnName(String colname) {
        return "\\\"" + colname + "\\\"";
    }

    public static String extractFirstDelimitedString(String text, String delimiter) {
        int end;
        String returned = "";
        int start = text.indexOf(delimiter, 0);
        if (start != -1 && (end = text.indexOf(delimiter, start + 1)) != -1) {
            returned = text.substring(start + 1, end);
        }
        return returned;
    }

    public static String protectMetachar(String input) {
        input = StringUtils.replace(input, "\\", "\\\\\\\\");
        input = StringUtils.replace(input, "+", "\\\\+");
        input = StringUtils.replace(input, ".", "\\\\.");
        input = StringUtils.replace(input, "[", "\\\\[");
        input = StringUtils.replace(input, "]", "\\]");
        input = StringUtils.replace(input, "(", "\\\\(");
        input = StringUtils.replace(input, ")", "\\\\)");
        input = StringUtils.replace(input, "^", "\\\\^");
        input = StringUtils.replace(input, "$", "\\\\$");
        return input;
    }

    public static String removeSpecialCharsForPackage(String input) {
        input = input.replaceAll(" ", "");
        input = input.replaceAll("/", ".");
        input = input.replaceAll("&", "and");
        input = input.replaceAll("<", "lt");
        input = input.replaceAll(">", "gt");
        input = input.replaceAll("'", "apos");
        input = input.replaceAll("\"", "quot");
        input = input.replaceAll("\\(", "_");
        input = input.replaceAll("\\)", "_");
        return input;
    }

    public static String loadConvert(String inputStr, String language) {
        if (inputStr == null) {
            return null;
        }
        char[] inputChars = new char[inputStr.length()];
        inputStr.getChars(0, inputStr.length(), inputChars, 0);
        String loadConvert = null;
        loadConvert = language.equalsIgnoreCase("perl") ? StringUtils.loadConvert(inputChars, 0, inputStr.length(), new char[inputStr.length()], 'x') : StringUtils.loadConvert(inputChars, 0, inputStr.length(), new char[inputStr.length()], 'u');
        return loadConvert;
    }

    private static String loadConvert(char[] in, int off, int len, char[] convtBuf, char preHex) {
        boolean limitLengthForHex = false;
        int limitLength = 0;
        if (preHex == 'u') {
            limitLengthForHex = true;
            limitLength = 4;
        } else if (preHex == 'x') {
            limitLengthForHex = false;
            limitLength = 2;
        } else {
            throw new IllegalArgumentException("only support the \\uxxxx or \\xhh encoding.");
        }
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            char aChar;
            if ((aChar = in[off++]) == '\\') {
                int i;
                int value;
                if (off < len && (in[off] == preHex || in[off] == 't' || in[off] == 'r' || in[off] == 'n' || in[off] == 'f' || Character.isDigit(in[off]))) {
                    aChar = in[off++];
                }
                if (aChar == preHex) {
                    value = 0;
                    block9: for (i = 0; i < limitLength; ++i) {
                        if (off == len) {
                            if (!limitLengthForHex) break;
                            throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                        }
                        if (limitLengthForHex) {
                            aChar = in[off++];
                        } else {
                            if (!Character.isDigit(in[off])) break;
                            aChar = in[off++];
                        }
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                continue block9;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block9;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block9;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 't') {
                    aChar = '\t';
                } else if (aChar == 'r') {
                    aChar = '\r';
                } else if (aChar == 'n') {
                    aChar = '\n';
                } else if (aChar == 'f') {
                    aChar = '\f';
                } else if (Character.isDigit(aChar)) {
                    value = 0;
                    for (i = 0; i < 3; ++i) {
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': {
                                value = (value << 3) + aChar - 48;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\0xxx encoding.");
                            }
                        }
                        if (off >= len || !Character.isDigit(in[off])) break;
                        aChar = in[off++];
                    }
                    aChar = (char)value;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    public static String escapeChar(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        StringBuffer sb = new StringBuffer(length);
        block9: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append("\\").append('n');
                    continue block9;
                }
                case '\r': {
                    sb.append("\\").append('r');
                    continue block9;
                }
                case '\t': {
                    sb.append("\\").append('t');
                    continue block9;
                }
                case '\f': {
                    sb.append("\\").append('f');
                    continue block9;
                }
                case '\b': {
                    sb.append("\\").append('b');
                    continue block9;
                }
                case '\"': {
                    sb.append("\\").append('\"');
                    continue block9;
                }
                case '\'': {
                    sb.append("\\").append('\'');
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String subString(String str, int len) {
        if (len < 0) {
            return str;
        }
        if ("".equals(str) || str == null) {
            return null;
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }

    public static String replacePrms(String text, Object ... arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            text = StringUtils.replace(text, OPEN_BRACE + i + CLOSE_BRACE, String.valueOf(arguments[i]));
        }
        return text;
    }

    public static int compareStringDigit(String s1, String s2, boolean ignoreCase) {
        return STR_DIGIT_COMPARATOR.compare(s1, s2, ignoreCase);
    }

    public static int compareStringDigit(String s1, String s2) {
        return STR_DIGIT_COMPARATOR.compare(s1, s2);
    }

    static class StringDigitComparator
    implements Comparator<String> {
        final Pattern DIGIT_PATTERN = Pattern.compile("^(\\d+)");

        StringDigitComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return this.compare(s1, s2, true);
        }

        public int compare(String s1, String s2, boolean ignoreCase) {
            int n1 = s1.length();
            int n2 = s2.length();
            int i1 = 0;
            for (int i2 = 0; i1 < n1 && i2 < n2; ++i1, ++i2) {
                char c1 = s1.charAt(i1);
                char c2 = s2.charAt(i2);
                if (Character.isDigit(c1) && Character.isDigit(c2)) {
                    String tmp1 = s1.substring(i1);
                    String tmp2 = s2.substring(i2);
                    Matcher matcher1 = this.DIGIT_PATTERN.matcher(tmp1);
                    Matcher matcher2 = this.DIGIT_PATTERN.matcher(tmp2);
                    if (matcher1.find() && matcher2.find()) {
                        int d2;
                        String digit1 = matcher1.group(1);
                        String digit2 = matcher2.group(1);
                        int d1 = Integer.parseInt(digit1);
                        if (d1 == (d2 = Integer.parseInt(digit2))) {
                            String left1 = tmp1.substring(digit1.length());
                            String left2 = tmp2.substring(digit2.length());
                            return this.compare(left1, left2, ignoreCase);
                        }
                        return d1 - d2;
                    }
                }
                if (c1 == c2) continue;
                if (ignoreCase) {
                    if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
                    return c1 - c2;
                }
                return c1 - c2;
            }
            return n1 - n2;
        }
    }
}

