/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commandline.client.command.extension;

import org.talend.commandline.client.command.extension.AbstractServerCommand;
import org.talend.commandline.client.util.CommandStringBuilder;

public class BuildJobServerCommand
extends AbstractServerCommand {
    public BuildJobServerCommand() {
    }

    public BuildJobServerCommand(String destDir, String archiveFileName, String jobName, String jobContext, String jobVersion, boolean applyContextToChildren) {
        this(destDir, archiveFileName, jobName, jobContext, jobVersion, applyContextToChildren, false, false, false, false);
    }

    public BuildJobServerCommand(String destDir, String archiveFileName, String jobName, String jobContext, String jobVersion, boolean applyContextToChildren, boolean addStatisticsCode, boolean exportToOSGI) {
        this(destDir, archiveFileName, jobName, jobContext, jobVersion, applyContextToChildren, addStatisticsCode, exportToOSGI, false, false);
    }

    public BuildJobServerCommand(String destDir, String archiveFileName, String jobName, String jobContext, String jobVersion, boolean applyContextToChildren, boolean addStatisticsCode, boolean exportToOSGI, boolean addAntScript, boolean addMavenScript) {
        this(destDir, archiveFileName, jobName, jobContext, jobVersion, null, null, applyContextToChildren, addStatisticsCode, exportToOSGI, addAntScript, addMavenScript, false, false, false, false, false, false);
    }

    public BuildJobServerCommand(String destDir, String archiveFileName, String jobName, String jobContext, String jobVersion, boolean applyContextToChildren, boolean exportToOSGI) {
        this(destDir, archiveFileName, jobName, jobContext, jobVersion, applyContextToChildren, false, exportToOSGI, false, false);
    }

    public BuildJobServerCommand(String destDir, String archiveFileName, String jobName, String jobContext, String jobVersion, String log4jLevel, boolean applyContextToChildren, boolean addStatisticsCode, boolean exportToOSGI, boolean addAntScript, boolean addMavenScript) {
        this(destDir, archiveFileName, jobName, jobContext, jobVersion, null, log4jLevel, applyContextToChildren, addStatisticsCode, exportToOSGI, addAntScript, addMavenScript, false, false, false, false, false, false);
    }

    public BuildJobServerCommand(String destDir, String archiveFileName, String jobName, String jobContext, String jobVersion, String log4jLevel, boolean applyContextToChildren, boolean addStatisticsCode, boolean exportToOSGI) {
        this(destDir, archiveFileName, jobName, jobContext, jobVersion, null, log4jLevel, applyContextToChildren, addStatisticsCode, exportToOSGI, false, false, true, true, true, false, true, true);
    }

    public BuildJobServerCommand(String destDir, String archiveFileName, String jobName, String jobContext, String jobVersion, String jobType, String log4jLevel, boolean applyContextToChildren, boolean addStatisticsCode, boolean exportToOSGI, boolean addAntScript, boolean addMavenScript, boolean includeLibs, boolean includeContext, boolean includeSrc, boolean includeTestSrc, boolean executeTests, boolean isBin) {
        this();
        this.setValue("JOB_NAME", jobName);
        this.setValue("DESTINATION_DIRECTORY", destDir);
        this.setValue("AECHIVE_FILENAME", archiveFileName);
        this.setValue("JOB_CONTEXT", jobContext);
        this.setValue("JOB_VERSION", jobVersion);
        this.setValue("JOB_TYPE", jobType);
        this.setValue("JOB_ADD_LOG4J_LEVEL", log4jLevel);
        this.setValue("JOB_APPLY_CONTEXT_TO_CHILDREN", applyContextToChildren);
        this.setValue("JOB_ADD_STATISTICS_CODE", addStatisticsCode);
        this.setValue("JOB_EXPORT_TO_OSGI_CODE", exportToOSGI);
        this.setValue("JOB_ADD_ANT_SCRIPT", addAntScript);
        this.setValue("JOB_ADD_MAVEN_SCRIPT", addMavenScript);
        this.setValue("JOB_INCLUDE_LIBS", includeLibs);
        this.setValue("JOB_INCLUDE_CONTEXT", includeContext);
        this.setValue("JOB_INCLUDE_JAVA_SOURCE", includeSrc);
        this.setValue("JOB_INCLUDE_TEST_SOURCE", includeTestSrc);
        this.setValue("JOB_EXECUTE_TESTS", executeTests);
        this.setValue("JOB_BINARIES", isBin);
    }

    @Override
    public String writeToString() {
        boolean enable;
        String buildType;
        String type;
        String jobVersion;
        String log4jLevel;
        String jobContext;
        String archiveFileName;
        CommandStringBuilder builder = new CommandStringBuilder("buildJob");
        builder.addArgument(this.getJobName());
        String destDir = this.getDestDir();
        if (destDir != null) {
            builder.addOptionWithArgument("dd", destDir);
        }
        if ((archiveFileName = this.getArchiveFileName()) != null) {
            builder.addOptionWithArgument("af", archiveFileName);
        }
        if ((jobContext = this.getJobContext()) != null) {
            builder.addOptionWithArgument("jc", jobContext);
        }
        if ((log4jLevel = this.getLog4jLevel()) != null) {
            builder.addOptionWithArgument("jall", log4jLevel);
        }
        if ((jobVersion = this.getJobVersion()) != null) {
            builder.addOptionWithArgument("jv", jobVersion);
        }
        if ((type = this.getJobType()) != null) {
            builder.addOptionWithArgument("jt", type);
        }
        if ((buildType = this.getBuildType()) != null) {
            builder.addOptionWithArgument("bt", buildType);
        }
        if (enable = this.isEnableMetrics()) {
            builder.addOption("em");
        }
        if (this.isApplyContextToChildren()) {
            builder.addOption("jactc");
        }
        if (this.isAddStatisticsCode()) {
            builder.addOption("jstats");
        }
        if (this.isExportToOSGI()) {
            builder.addOption("eo");
        }
        if (this.isAddAntScript()) {
            builder.addOption("ant");
        }
        if (this.isAddMavenScript()) {
            builder.addOption("maven");
        }
        if (this.isIncludeLibs()) {
            builder.addOption("il");
        }
        if (this.isIncludeContext()) {
            builder.addOption("ic");
        }
        if (this.isIncludeJavaSource()) {
            builder.addOption("ijs");
        }
        if (this.isIncludeTestSource()) {
            builder.addOption("its");
        }
        if (this.isExecuteTests()) {
            builder.addOption("et");
        }
        if (this.isBinaries()) {
            builder.addOption("bin");
        }
        return builder.toString();
    }

    public String getJobName() {
        return (String)this.getValue("JOB_NAME");
    }

    public String getDestDir() {
        return (String)this.getValue("DESTINATION_DIRECTORY");
    }

    public String getArchiveFileName() {
        return (String)this.getValue("AECHIVE_FILENAME");
    }

    public String getJobContext() {
        return (String)this.getValue("JOB_CONTEXT");
    }

    public String getJobVersion() {
        return (String)this.getValue("JOB_VERSION");
    }

    public boolean isApplyContextToChildren() {
        return this.getBooleanValue("JOB_APPLY_CONTEXT_TO_CHILDREN");
    }

    public boolean isAddStatisticsCode() {
        return this.getBooleanValue("JOB_ADD_STATISTICS_CODE");
    }

    public boolean isExportToOSGI() {
        return this.getBooleanValue("JOB_EXPORT_TO_OSGI_CODE");
    }

    public boolean isAddMavenScript() {
        return this.getBooleanValue("JOB_ADD_MAVEN_SCRIPT");
    }

    public boolean isAddAntScript() {
        return this.getBooleanValue("JOB_ADD_ANT_SCRIPT");
    }

    public String getLog4jLevel() {
        return (String)this.getValue("JOB_ADD_LOG4J_LEVEL");
    }

    public String getJobType() {
        return (String)this.getValue("JOB_TYPE");
    }

    public String getBuildType() {
        return (String)this.getValue("JOB_BUILD_TYPE");
    }

    public boolean isIncludeLibs() {
        return this.getBooleanValue("JOB_INCLUDE_LIBS");
    }

    public boolean isIncludeContext() {
        return this.getBooleanValue("JOB_INCLUDE_CONTEXT");
    }

    public boolean isIncludeJavaSource() {
        return this.getBooleanValue("JOB_INCLUDE_JAVA_SOURCE");
    }

    public boolean isIncludeTestSource() {
        return this.getBooleanValue("JOB_INCLUDE_TEST_SOURCE");
    }

    public boolean isExecuteTests() {
        return this.getBooleanValue("JOB_EXECUTE_TESTS");
    }

    public boolean isBinaries() {
        return this.getBooleanValue("JOB_BINARIES");
    }

    public boolean isExportAsZip() {
        return this.getBooleanValue("JOB_EXPORT_AS_ZIP");
    }

    public boolean isEnableMetrics() {
        return this.getBooleanValue("JOB_ENABLE_PROMETHEUS_METRICS_ENDPOINT");
    }

    public boolean isOnlyExportDefaultContext() {
        return this.getBooleanValue("JOB_EXPORT_ONLY_DEFAULT_CONTEXT");
    }
}

