/*
 * Decompiled with CFR 0.152.
 */
package org.talend.camel.internal;

import java.util.Collection;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.talend.camel.JobResolver;
import org.talend.camel.JobResolverHolder;
import routines.system.api.TalendESBJobFactory;

public class Activator
implements BundleActivator,
JobResolver {
    private static final long SERVICE_REFERENCE_TIMEOUT = 10000L;
    private static BundleContext context;

    public void start(BundleContext ctx) throws Exception {
        context = ctx;
        JobResolverHolder.setJobResolver(this);
    }

    public void stop(BundleContext ctx) throws Exception {
        context = null;
    }

    @Override
    public TalendESBJobFactory getJobService(String jobOwner, String fullJobName, boolean isMandatory) throws Exception {
        String newFilter;
        String simpleName = fullJobName.substring(fullJobName.lastIndexOf(46) + 1);
        String oldFilter = "(&(name=" + simpleName + ")(type=job))";
        Collection<ServiceReference<TalendESBJobFactory>> serviceReferences = Activator.getCurrentServiceReferences(oldFilter, newFilter = "(&(name=" + fullJobName + ")(type=job))");
        ServiceReference<TalendESBJobFactory> serviceReference = Activator.validServiceReference(serviceReferences, jobOwner, simpleName);
        if (serviceReference == null && isMandatory) {
            ServiceReferenceRetriever retriever = new ServiceReferenceRetriever(oldFilter, newFilter, jobOwner, simpleName);
            retriever.initialize();
            serviceReference = retriever.getServiceReference(10000L);
        }
        return serviceReference == null ? null : (TalendESBJobFactory)context.getService(serviceReference);
    }

    private static Collection<ServiceReference<TalendESBJobFactory>> getCurrentServiceReferences(String oldFilter, String newFilter) throws InvalidSyntaxException {
        if (context == null) {
            return null;
        }
        Collection serviceReferences = context.getServiceReferences(TalendESBJobFactory.class, oldFilter);
        if (null == serviceReferences || serviceReferences.isEmpty()) {
            serviceReferences = context.getServiceReferences(TalendESBJobFactory.class, newFilter);
        }
        return serviceReferences;
    }

    private static ServiceReference<TalendESBJobFactory> validServiceReference(Collection<ServiceReference<TalendESBJobFactory>> serviceReferences, String jobOwner, String simpleName) {
        if (serviceReferences == null || serviceReferences.isEmpty()) {
            return null;
        }
        if (jobOwner == null) {
            return serviceReferences.iterator().next();
        }
        String jobBundleName = jobOwner + "_" + simpleName;
        for (ServiceReference<TalendESBJobFactory> sref : serviceReferences) {
            String symName = sref.getBundle().getSymbolicName();
            String shortName = symName.substring(symName.lastIndexOf(46) + 1);
            if (!jobBundleName.equals(shortName)) continue;
            return sref;
        }
        return null;
    }

    private static ServiceReference<TalendESBJobFactory> validServiceReference(ServiceReference<TalendESBJobFactory> serviceReference, String jobOwner, String simpleName) {
        String symName;
        String shortName;
        if (serviceReference == null) {
            return null;
        }
        if (jobOwner == null) {
            return serviceReference;
        }
        String jobBundleName = jobOwner + "_" + simpleName;
        if (jobBundleName.equals(shortName = (symName = serviceReference.getBundle().getSymbolicName()).substring(symName.lastIndexOf(46) + 1))) {
            return serviceReference;
        }
        return null;
    }

    private static class ServiceReferenceRetriever {
        private final String oldFilter;
        private final String newFilter;
        private final String jobOwner;
        private final String simpleName;
        private final ServiceListener listener;
        private ServiceReference<TalendESBJobFactory> serviceReference = null;

        public ServiceReferenceRetriever(String oldFilter, String newFilter, final String jobOwner, final String simpleName) {
            this.oldFilter = oldFilter;
            this.newFilter = newFilter;
            this.jobOwner = jobOwner;
            this.simpleName = simpleName;
            if (context == null) {
                throw new IllegalStateException("Bundle not initialized. ");
            }
            this.listener = new ServiceListener(){

                public void serviceChanged(ServiceEvent event) {
                    if (event.getType() == 1) {
                        this.setServiceReference((ServiceReference<TalendESBJobFactory>)Activator.validServiceReference((ServiceReference<TalendESBJobFactory>)event.getServiceReference(), jobOwner, simpleName));
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initialize() throws InvalidSyntaxException {
            boolean success = false;
            try {
                String filter = "(|" + this.oldFilter + this.newFilter + ")";
                context.addServiceListener(this.listener, filter);
                Collection serviceReferences = Activator.getCurrentServiceReferences(this.oldFilter, this.newFilter);
                this.setServiceReference((ServiceReference<TalendESBJobFactory>)Activator.validServiceReference(serviceReferences, this.jobOwner, this.simpleName));
                success = true;
            }
            finally {
                if (!success) {
                    context.removeServiceListener(this.listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized ServiceReference<TalendESBJobFactory> getServiceReference(long timeout) {
            try {
                long waitTime;
                if (this.serviceReference != null) {
                    ServiceReference<TalendESBJobFactory> serviceReference = this.serviceReference;
                    return serviceReference;
                }
                long endTime = System.currentTimeMillis() + timeout;
                while (this.serviceReference == null && (waitTime = endTime - System.currentTimeMillis()) > 0L) {
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                ServiceReference<TalendESBJobFactory> serviceReference = this.serviceReference;
                return serviceReference;
            }
            finally {
                context.removeServiceListener(this.listener);
            }
        }

        private synchronized void setServiceReference(ServiceReference<TalendESBJobFactory> serviceReference) {
            if (this.serviceReference != null || serviceReference == null) {
                return;
            }
            this.serviceReference = serviceReference;
            this.notifyAll();
        }
    }
}

