/*
 * Decompiled with CFR 0.152.
 */
package org.talend.camel;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.DefaultEndpoint;
import org.talend.camel.JobResolver;
import org.talend.camel.JobResolverHolder;
import org.talend.camel.TalendComponent;
import org.talend.camel.TalendProducer;
import routines.system.api.TalendESBJobFactory;
import routines.system.api.TalendJob;

public class TalendEndpoint
extends DefaultEndpoint {
    private String clazz;
    private String owner;
    private String context;
    private Map<String, String> endpointProperties;
    private String componentId = null;
    private boolean propagateHeader = true;
    private boolean stickyJob = false;

    public TalendEndpoint(String uri, String clazz, TalendComponent component) {
        super(uri, (Component)component);
        this.setOwnerAndClazz(clazz);
    }

    public Producer createProducer() throws Exception {
        return new TalendProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new RuntimeCamelException("No support for exposing Camel as Talend job yet");
    }

    public boolean isSingleton() {
        return true;
    }

    public void setClazz(String clazz) {
        this.setOwnerAndClazz(clazz);
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public boolean isPropagateHeader() {
        return this.propagateHeader;
    }

    public void setPropagateHeader(boolean propagateHeader) {
        this.propagateHeader = propagateHeader;
    }

    public boolean isStickyJob() {
        return this.stickyJob;
    }

    public void setStickyJob(boolean stickyJob) {
        this.stickyJob = stickyJob;
    }

    public TalendJob getJobInstance(boolean isMandatory) throws Exception {
        JobResolver jobResolver = JobResolverHolder.getJobResolver();
        if (null != jobResolver) {
            TalendESBJobFactory talendESBJobFactory = jobResolver.getJobService(this.owner, this.clazz, isMandatory);
            if (null != talendESBJobFactory) {
                return talendESBJobFactory.newTalendESBJob();
            }
            if (!isMandatory) {
                return null;
            }
        }
        Class jobType = this.getCamelContext().getClassResolver().resolveMandatoryClass(this.clazz);
        return (TalendJob)this.getCamelContext().getInjector().newInstance(jobType);
    }

    public Map<String, String> getEndpointProperties() {
        return this.endpointProperties;
    }

    public void setEndpointProperties(Map<String, String> endpointProperties) {
        this.endpointProperties = endpointProperties;
    }

    private void setOwnerAndClazz(String rawClazz) {
        if (rawClazz == null) {
            this.owner = null;
            this.clazz = null;
            return;
        }
        int ndx = rawClazz.lastIndexOf(47);
        if (ndx < 0) {
            this.owner = null;
            this.clazz = rawClazz;
            return;
        }
        this.owner = rawClazz.substring(0, ndx);
        this.clazz = rawClazz.substring(ndx + 1);
    }
}

