/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client;

import java.io.Serializable;
import org.apache.hive.spark.client.Job;
import org.apache.hive.spark.client.metrics.Metrics;
import org.apache.hive.spark.client.rpc.RpcDispatcher;
import org.apache.hive.spark.counter.SparkCounters;

public abstract class BaseProtocol
extends RpcDispatcher {

    protected static class SyncJobRequest<T extends Serializable>
    implements Serializable {
        final Job<T> job;

        SyncJobRequest(Job<T> job) {
            this.job = job;
        }

        SyncJobRequest() {
            this(null);
        }

        public String toString() {
            return "SyncJobRequest{job=" + this.job + '}';
        }
    }

    protected static class JobSubmitted
    implements Serializable {
        final String clientJobId;
        final int sparkJobId;

        JobSubmitted(String clientJobId, int sparkJobId) {
            this.clientJobId = clientJobId;
            this.sparkJobId = sparkJobId;
        }

        JobSubmitted() {
            this(null, -1);
        }

        public String toString() {
            return "JobSubmitted{clientJobId='" + this.clientJobId + '\'' + ", sparkJobId=" + this.sparkJobId + '}';
        }
    }

    protected static class JobStarted
    implements Serializable {
        final String id;

        JobStarted(String id) {
            this.id = id;
        }

        JobStarted() {
            this(null);
        }

        public String toString() {
            return "JobStarted{id='" + this.id + '\'' + '}';
        }
    }

    public static class JobResult<T extends Serializable>
    implements Serializable {
        final String id;
        final T result;
        final Throwable error;
        final SparkCounters sparkCounters;

        JobResult(String id, T result, Throwable error, SparkCounters sparkCounters) {
            this.id = id;
            this.result = result;
            this.error = error;
            this.sparkCounters = sparkCounters;
        }

        JobResult() {
            this(null, null, null, null);
        }

        public String toString() {
            return "JobResult{id='" + this.id + '\'' + ", result=" + this.result + ", error=" + this.error + ", sparkCounters=" + this.sparkCounters + '}';
        }
    }

    protected static class JobRequest<T extends Serializable>
    implements Serializable {
        final String id;
        final Job<T> job;

        JobRequest(String id, Job<T> job) {
            this.id = id;
            this.job = job;
        }

        JobRequest() {
            this(null, null);
        }

        public String toString() {
            return "JobRequest{id='" + this.id + '\'' + ", job=" + this.job + '}';
        }
    }

    protected static class JobMetrics
    implements Serializable {
        final String jobId;
        final int sparkJobId;
        final int stageId;
        final long taskId;
        final Metrics metrics;

        JobMetrics(String jobId, int sparkJobId, int stageId, long taskId, Metrics metrics) {
            this.jobId = jobId;
            this.sparkJobId = sparkJobId;
            this.stageId = stageId;
            this.taskId = taskId;
            this.metrics = metrics;
        }

        JobMetrics() {
            this(null, -1, -1, -1L, null);
        }

        public String toString() {
            return "JobMetrics{jobId='" + this.jobId + '\'' + ", sparkJobId=" + this.sparkJobId + ", stageId=" + this.stageId + ", taskId=" + this.taskId + ", metrics=" + this.metrics + '}';
        }
    }

    protected static class Error
    implements Serializable {
        final String cause;

        Error(String cause) {
            this.cause = cause;
        }

        Error() {
            this(null);
        }

        public String toString() {
            return "Error{cause='" + this.cause + '\'' + '}';
        }
    }

    protected static class EndSession
    implements Serializable {
        protected EndSession() {
        }

        public String toString() {
            return "EndSession";
        }
    }

    protected static class CancelJob
    implements Serializable {
        final String id;

        CancelJob(String id) {
            this.id = id;
        }

        CancelJob() {
            this(null);
        }

        public String toString() {
            return "CancelJob{id='" + this.id + '\'' + '}';
        }
    }
}

