/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.parquet.hadoop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hive.org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.hive.org.apache.parquet.bytes.BytesInput;
import org.apache.hive.org.apache.parquet.bytes.ConcatenatingByteArrayCollector;
import org.apache.hive.org.apache.parquet.column.ColumnDescriptor;
import org.apache.hive.org.apache.parquet.column.Encoding;
import org.apache.hive.org.apache.parquet.column.page.DictionaryPage;
import org.apache.hive.org.apache.parquet.column.page.PageWriteStore;
import org.apache.hive.org.apache.parquet.column.page.PageWriter;
import org.apache.hive.org.apache.parquet.column.statistics.Statistics;
import org.apache.hive.org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.hive.org.apache.parquet.hadoop.CodecFactory;
import org.apache.hive.org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.hive.org.apache.parquet.io.ParquetEncodingException;
import org.apache.hive.org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ColumnChunkPageWriteStore
implements PageWriteStore {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnChunkPageWriteStore.class);
    private static ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
    private final Map<ColumnDescriptor, ColumnChunkPageWriter> writers = new HashMap<ColumnDescriptor, ColumnChunkPageWriter>();
    private final MessageType schema;

    public ColumnChunkPageWriteStore(CodecFactory.BytesCompressor compressor, MessageType schema, ByteBufferAllocator allocator) {
        this.schema = schema;
        for (ColumnDescriptor path : schema.getColumns()) {
            this.writers.put(path, new ColumnChunkPageWriter(path, compressor, allocator));
        }
    }

    @Override
    public PageWriter getPageWriter(ColumnDescriptor path) {
        return this.writers.get(path);
    }

    public void flushToFileWriter(ParquetFileWriter writer) throws IOException {
        for (ColumnDescriptor path : this.schema.getColumns()) {
            ColumnChunkPageWriter pageWriter = this.writers.get(path);
            pageWriter.writeToFileWriter(writer);
        }
    }

    private static final class ColumnChunkPageWriter
    implements PageWriter {
        private final ColumnDescriptor path;
        private final CodecFactory.BytesCompressor compressor;
        private final ByteArrayOutputStream tempOutputStream = new ByteArrayOutputStream();
        private final ConcatenatingByteArrayCollector buf;
        private DictionaryPage dictionaryPage;
        private long uncompressedLength;
        private long compressedLength;
        private long totalValueCount;
        private int pageCount;
        private Set<Encoding> rlEncodings = new HashSet<Encoding>();
        private Set<Encoding> dlEncodings = new HashSet<Encoding>();
        private List<Encoding> dataEncodings = new ArrayList<Encoding>();
        private Statistics totalStatistics;
        private final ByteBufferAllocator allocator;

        private ColumnChunkPageWriter(ColumnDescriptor path, CodecFactory.BytesCompressor compressor, ByteBufferAllocator allocator) {
            this.path = path;
            this.compressor = compressor;
            this.allocator = allocator;
            this.buf = new ConcatenatingByteArrayCollector();
        }

        public void writePage(BytesInput bytes, int valueCount, Statistics statistics, Encoding rlEncoding, Encoding dlEncoding, Encoding valuesEncoding) throws IOException {
            long uncompressedSize = bytes.size();
            if (uncompressedSize > Integer.MAX_VALUE) {
                throw new ParquetEncodingException("Cannot write page larger than Integer.MAX_VALUE bytes: " + uncompressedSize);
            }
            BytesInput compressedBytes = this.compressor.compress(bytes);
            long compressedSize = compressedBytes.size();
            if (compressedSize > Integer.MAX_VALUE) {
                throw new ParquetEncodingException("Cannot write compressed page larger than Integer.MAX_VALUE bytes: " + compressedSize);
            }
            this.tempOutputStream.reset();
            parquetMetadataConverter.writeDataPageHeader((int)uncompressedSize, (int)compressedSize, valueCount, statistics, rlEncoding, dlEncoding, valuesEncoding, this.tempOutputStream);
            this.uncompressedLength += uncompressedSize;
            this.compressedLength += compressedSize;
            this.totalValueCount += (long)valueCount;
            ++this.pageCount;
            if (this.totalStatistics == null) {
                this.totalStatistics = statistics.copy();
            } else {
                this.totalStatistics.mergeStatistics(statistics);
            }
            this.buf.collect(BytesInput.concat(BytesInput.from(this.tempOutputStream), compressedBytes));
            this.rlEncodings.add(rlEncoding);
            this.dlEncodings.add(dlEncoding);
            this.dataEncodings.add(valuesEncoding);
        }

        @Override
        public void writePageV2(int rowCount, int nullCount, int valueCount, BytesInput repetitionLevels, BytesInput definitionLevels, Encoding dataEncoding, BytesInput data, Statistics<?> statistics) throws IOException {
            int rlByteLength = this.toIntWithCheck(repetitionLevels.size());
            int dlByteLength = this.toIntWithCheck(definitionLevels.size());
            int uncompressedSize = this.toIntWithCheck(data.size() + repetitionLevels.size() + definitionLevels.size());
            BytesInput compressedData = this.compressor.compress(data);
            int compressedSize = this.toIntWithCheck(compressedData.size() + repetitionLevels.size() + definitionLevels.size());
            this.tempOutputStream.reset();
            parquetMetadataConverter.writeDataPageV2Header(uncompressedSize, compressedSize, valueCount, nullCount, rowCount, statistics, dataEncoding, rlByteLength, dlByteLength, this.tempOutputStream);
            this.uncompressedLength += (long)uncompressedSize;
            this.compressedLength += (long)compressedSize;
            this.totalValueCount += (long)valueCount;
            ++this.pageCount;
            if (this.totalStatistics == null) {
                this.totalStatistics = statistics.copy();
            } else {
                this.totalStatistics.mergeStatistics(statistics);
            }
            this.buf.collect(BytesInput.concat(BytesInput.from(this.tempOutputStream), repetitionLevels, definitionLevels, compressedData));
            this.dataEncodings.add(dataEncoding);
        }

        private int toIntWithCheck(long size) {
            if (size > Integer.MAX_VALUE) {
                throw new ParquetEncodingException("Cannot write page larger than 2147483647 bytes: " + size);
            }
            return (int)size;
        }

        @Override
        public long getMemSize() {
            return this.buf.size();
        }

        public void writeToFileWriter(ParquetFileWriter writer) throws IOException {
            writer.startColumn(this.path, this.totalValueCount, this.compressor.getCodecName());
            if (this.dictionaryPage != null) {
                writer.writeDictionaryPage(this.dictionaryPage);
            }
            writer.writeDataPages(this.buf, this.uncompressedLength, this.compressedLength, this.totalStatistics, this.rlEncodings, this.dlEncodings, this.dataEncodings);
            writer.endColumn();
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("written %,dB for %s: %,d values, %,dB raw, %,dB comp, %d pages, encodings: %s", this.buf.size(), this.path, this.totalValueCount, this.uncompressedLength, this.compressedLength, this.pageCount, new HashSet<Encoding>(this.dataEncodings)) + (this.dictionaryPage != null ? String.format(", dic { %,d entries, %,dB raw, %,dB comp}", this.dictionaryPage.getDictionarySize(), this.dictionaryPage.getUncompressedSize(), this.dictionaryPage.getDictionarySize()) : ""));
            }
            this.rlEncodings.clear();
            this.dlEncodings.clear();
            this.dataEncodings.clear();
            this.pageCount = 0;
        }

        @Override
        public long allocatedSize() {
            return this.buf.size();
        }

        @Override
        public void writeDictionaryPage(DictionaryPage dictionaryPage) throws IOException {
            if (this.dictionaryPage != null) {
                throw new ParquetEncodingException("Only one dictionary page is allowed");
            }
            BytesInput dictionaryBytes = dictionaryPage.getBytes();
            int uncompressedSize = (int)dictionaryBytes.size();
            BytesInput compressedBytes = this.compressor.compress(dictionaryBytes);
            this.dictionaryPage = new DictionaryPage(BytesInput.copy(compressedBytes), uncompressedSize, dictionaryPage.getDictionarySize(), dictionaryPage.getEncoding());
        }

        @Override
        public String memUsageString(String prefix) {
            return this.buf.memUsageString(prefix + " ColumnChunkPageWriter");
        }
    }
}

