/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.parquet.column.values.plain;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hive.org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.hive.org.apache.parquet.bytes.LittleEndianDataInputStream;
import org.apache.hive.org.apache.parquet.column.values.ValuesReader;
import org.apache.hive.org.apache.parquet.io.ParquetDecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PlainValuesReader
extends ValuesReader {
    private static final Logger LOG = LoggerFactory.getLogger(PlainValuesReader.class);
    protected LittleEndianDataInputStream in;

    @Override
    public void initFromPage(int valueCount, ByteBuffer in, int offset) throws IOException {
        LOG.debug("init from page at offset {} for length {}", (Object)offset, (Object)(in.limit() - offset));
        this.in = new LittleEndianDataInputStream(this.toInputStream(in, offset));
    }

    private ByteBufferInputStream toInputStream(ByteBuffer in, int offset) {
        return new ByteBufferInputStream(in.duplicate(), offset, in.limit() - offset);
    }

    public static class LongPlainValuesReader
    extends PlainValuesReader {
        @Override
        public void skip() {
            try {
                this.in.skipBytes(8);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not skip long", e);
            }
        }

        @Override
        public long readLong() {
            try {
                return this.in.readLong();
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not read long", e);
            }
        }
    }

    public static class IntegerPlainValuesReader
    extends PlainValuesReader {
        @Override
        public void skip() {
            try {
                this.in.skipBytes(4);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not skip int", e);
            }
        }

        @Override
        public int readInteger() {
            try {
                return this.in.readInt();
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not read int", e);
            }
        }
    }

    public static class FloatPlainValuesReader
    extends PlainValuesReader {
        @Override
        public void skip() {
            try {
                this.in.skipBytes(4);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not skip float", e);
            }
        }

        @Override
        public float readFloat() {
            try {
                return this.in.readFloat();
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not read float", e);
            }
        }
    }

    public static class DoublePlainValuesReader
    extends PlainValuesReader {
        @Override
        public void skip() {
            try {
                this.in.skipBytes(8);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not skip double", e);
            }
        }

        @Override
        public double readDouble() {
            try {
                return this.in.readDouble();
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not read double", e);
            }
        }
    }
}

