/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.parquet.column.values.bitpacking;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hive.org.apache.parquet.column.values.bitpacking.BitPacking;

class TwoBitPackingWriter
extends BitPacking.BitPackingWriter {
    private OutputStream out;
    private int buffer = 0;
    private int count = 0;

    public TwoBitPackingWriter(OutputStream out) {
        this.out = out;
    }

    @Override
    public void write(int val) throws IOException {
        this.buffer <<= 2;
        this.buffer |= val;
        ++this.count;
        if (this.count == 4) {
            this.out.write(this.buffer);
            this.buffer = 0;
            this.count = 0;
        }
    }

    @Override
    public void finish() throws IOException {
        while (this.count != 0) {
            this.write(0);
        }
        this.out = null;
    }
}

