/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.parquet.column.values.bitpacking;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hive.org.apache.parquet.column.values.bitpacking.BaseBitPackingWriter;

class FiveBitPackingWriter
extends BaseBitPackingWriter {
    private OutputStream out;
    private long buffer = 0L;
    private int count = 0;

    public FiveBitPackingWriter(OutputStream out) {
        this.out = out;
    }

    @Override
    public void write(int val) throws IOException {
        this.buffer <<= 5;
        this.buffer |= (long)val;
        ++this.count;
        if (this.count == 8) {
            this.out.write((int)(this.buffer >>> 32) & 0xFF);
            this.out.write((int)(this.buffer >>> 24) & 0xFF);
            this.out.write((int)(this.buffer >>> 16) & 0xFF);
            this.out.write((int)(this.buffer >>> 8) & 0xFF);
            this.out.write((int)(this.buffer >>> 0) & 0xFF);
            this.buffer = 0L;
            this.count = 0;
        }
    }

    @Override
    public void finish() throws IOException {
        if (this.count != 0) {
            int numberOfBits = this.count * 5;
            this.finish(numberOfBits, this.buffer, this.out);
            this.buffer = 0L;
            this.count = 0;
        }
        this.out = null;
    }
}

