/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.exec.spark.SparkUtilities;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.TaskGraphWalker;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.optimizer.spark.SparkPartitionPruningSinkDesc;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.spark.SparkPartitionPruningSinkOperator;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkDynamicPartitionPruningResolver
implements PhysicalPlanResolver {
    private static final Logger LOG = LoggerFactory.getLogger((String)SparkDynamicPartitionPruningResolver.class.getName());

    @Override
    public PhysicalContext resolve(PhysicalContext pctx) throws SemanticException {
        TaskGraphWalker graphWalker = new TaskGraphWalker(new SparkDynamicPartitionPruningDispatcher());
        ArrayList<Node> rootTasks = new ArrayList<Node>();
        rootTasks.addAll(pctx.getRootTasks());
        graphWalker.startWalking(rootTasks, null);
        return pctx;
    }

    private void removeSparkPartitionPruningSink(BaseWork sourceWork, MapWork targetMapWork, SparkPartitionPruningSinkOperator pruningSinkOp) {
        OperatorUtils.removeBranch(pruningSinkOp);
        String sourceWorkId = SparkUtilities.getWorkId(sourceWork);
        SparkPartitionPruningSinkDesc pruningSinkDesc = (SparkPartitionPruningSinkDesc)pruningSinkOp.getConf();
        targetMapWork.getEventSourceTableDescMap().get(sourceWorkId).remove(pruningSinkDesc.getTable());
        targetMapWork.getEventSourceColumnNameMap().get(sourceWorkId).remove(pruningSinkDesc.getTargetColumnName());
        targetMapWork.getEventSourceColumnTypeMap().get(sourceWorkId).remove(pruningSinkDesc.getTargetColumnType());
        targetMapWork.getEventSourcePartKeyExprMap().get(sourceWorkId).remove(pruningSinkDesc.getPartKey());
    }

    private boolean taskContainsDependentMapWork(Task<? extends Serializable> task, MapWork work) throws SemanticException {
        if (task == null || task.getChildTasks() == null) {
            return false;
        }
        for (Task<Serializable> childTask : task.getChildTasks()) {
            if (childTask != null && childTask instanceof SparkTask && childTask.getMapWork().contains(work)) {
                return true;
            }
            if (!this.taskContainsDependentMapWork(childTask, work)) continue;
            return true;
        }
        return false;
    }

    private class SparkDynamicPartitionPruningDispatcher
    implements Dispatcher {
        private SparkDynamicPartitionPruningDispatcher() {
        }

        @Override
        public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
            Task task = (Task)nd;
            if (task instanceof SparkTask) {
                for (BaseWork baseWork : ((SparkWork)((SparkTask)task).getWork()).getAllWork()) {
                    Set<Operator<?>> pruningSinkOps = OperatorUtils.getOp(baseWork, SparkPartitionPruningSinkOperator.class);
                    for (Operator<?> op : pruningSinkOps) {
                        SparkPartitionPruningSinkOperator pruningSinkOp = (SparkPartitionPruningSinkOperator)op;
                        MapWork targetMapWork = ((SparkPartitionPruningSinkDesc)pruningSinkOp.getConf()).getTargetMapWork();
                        if (SparkDynamicPartitionPruningResolver.this.taskContainsDependentMapWork(task, targetMapWork)) continue;
                        LOG.info("Disabling DPP for source work " + baseWork.getName() + " for target work " + targetMapWork.getName() + " as no dependency exists between the source and target work");
                        SparkDynamicPartitionPruningResolver.this.removeSparkPartitionPruningSink(baseWork, targetMapWork, pruningSinkOp);
                    }
                }
            }
            return null;
        }
    }
}

