/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc.encoded;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hive.common.DiskRangeInfo;
import org.apache.hadoop.hive.common.io.encoded.EncodedColumnBatch;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.orc.impl.BufferChunk;
import org.apache.orc.impl.SettableUncompressedStream;

public class StreamUtils {
    public static SettableUncompressedStream createSettableUncompressedStream(String streamName, EncodedColumnBatch.ColumnStreamData streamBuffer) throws IOException {
        if (streamBuffer == null) {
            return null;
        }
        DiskRangeInfo diskRangeInfo = StreamUtils.createDiskRangeInfo(streamBuffer);
        return new SettableUncompressedStream(streamName, diskRangeInfo.getDiskRanges(), diskRangeInfo.getTotalLength());
    }

    public static DiskRangeInfo createDiskRangeInfo(EncodedColumnBatch.ColumnStreamData streamBuffer) {
        DiskRangeInfo diskRangeInfo = new DiskRangeInfo(streamBuffer.getIndexBaseOffset());
        long offset = streamBuffer.getIndexBaseOffset();
        for (MemoryBuffer memoryBuffer : streamBuffer.getCacheBuffers()) {
            ByteBuffer buffer = memoryBuffer.getByteBufferDup();
            diskRangeInfo.addDiskRange(new BufferChunk(buffer, offset));
            offset += (long)buffer.remaining();
        }
        return diskRangeInfo;
    }
}

