/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.OverflowUtils;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class LongScalarModuloLongColumnChecked
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private long value;
    private int outputColumn;

    public LongScalarModuloLongColumnChecked(long value, int colNum, int outputColumn) {
        this.colNum = colNum;
        this.value = value;
        this.outputColumn = outputColumn;
    }

    public LongScalarModuloLongColumnChecked() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector = (LongColumnVector)batch.cols[this.colNum];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        long[] vector = inputColVector.vector;
        long[] outputVector = outputColVector.vector;
        boolean hasDivBy0 = false;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                long denom = vector[0];
                boolean bl = hasDivBy0 = hasDivBy0 || denom == 0L;
                if (denom != 0L) {
                    outputVector[0] = this.value % denom;
                }
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
        } else if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        long denom = vector[i];
                        boolean bl = hasDivBy0 = hasDivBy0 || denom == 0L;
                        if (denom == 0L) continue;
                        outputVector[i] = this.value % denom;
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        long denom = vector[i];
                        boolean bl = hasDivBy0 = hasDivBy0 || denom == 0L;
                        if (denom == 0L) continue;
                        outputVector[i] = this.value % denom;
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    long denom = vector[i];
                    boolean bl = hasDivBy0 = hasDivBy0 || denom == 0L;
                    if (denom == 0L) continue;
                    outputVector[i] = this.value % denom;
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = inputIsNull[i];
                    long denom = vector[i];
                    boolean bl = hasDivBy0 = hasDivBy0 || denom == 0L;
                    if (denom == 0L) continue;
                    outputVector[i] = this.value % denom;
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    long denom = vector[i];
                    boolean bl = hasDivBy0 = hasDivBy0 || denom == 0L;
                    if (denom == 0L) continue;
                    outputVector[i] = this.value % denom;
                }
            }
        }
        OverflowUtils.accountForOverflowLong(this.getOutputTypeInfo(), outputColVector, batch.selectedInUse, sel, n);
        if (!hasDivBy0) {
            NullUtil.setNullOutputEntriesColScalar(outputColVector, batch.selectedInUse, sel, n);
        } else {
            NullUtil.setNullAndDivBy0DataEntriesLong(outputColVector, batch.selectedInUse, sel, n, inputColVector);
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "val " + this.value + ", col " + this.colNum;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("long")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

