/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IfExprDoubleScalarLongScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int arg1Column;
    private double arg2Scalar;
    private long arg3Scalar;
    private int outputColumn;

    public IfExprDoubleScalarLongScalar(int arg1Column, double arg2Scalar, long arg3Scalar, int outputColumn) {
        this.arg1Column = arg1Column;
        this.arg2Scalar = arg2Scalar;
        this.arg3Scalar = arg3Scalar;
        this.outputColumn = outputColumn;
    }

    public IfExprDoubleScalarLongScalar() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.arg1Column];
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        long[] vector1 = arg1ColVector.vector;
        double[] outputVector = outputColVector.vector;
        if (arg1ColVector.isRepeating) {
            if ((arg1ColVector.noNulls || !arg1ColVector.isNull[0]) && vector1[0] == 1L) {
                outputColVector.fill(this.arg2Scalar);
            } else {
                outputColVector.fill(this.arg3Scalar);
            }
            return;
        }
        if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        outputVector[i] = vector1[i] == 1L ? this.arg2Scalar : (double)this.arg3Scalar;
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = vector1[i] == 1L ? this.arg2Scalar : (double)this.arg3Scalar;
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector1[i] == 1L ? this.arg2Scalar : (double)this.arg3Scalar;
                }
            }
        } else if (batch.selectedInUse) {
            if (!outputColVector.noNulls) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = false;
                    outputVector[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? this.arg2Scalar : (double)this.arg3Scalar;
                }
            } else {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? this.arg2Scalar : (double)this.arg3Scalar;
                }
            }
        } else {
            if (!outputColVector.noNulls) {
                Arrays.fill(outputIsNull, false);
                outputColVector.noNulls = true;
            }
            for (int i = 0; i != n; ++i) {
                outputVector[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? this.arg2Scalar : (double)this.arg3Scalar;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public int getArg1Column() {
        return this.arg1Column;
    }

    public void setArg1Column(int colNum) {
        this.arg1Column = colNum;
    }

    public double getArg2Scalar() {
        return this.arg2Scalar;
    }

    public void setArg2Scalar(double value) {
        this.arg2Scalar = value;
    }

    public long getArg3Scalar() {
        return this.arg3Scalar;
    }

    public void setArg3Scalar(long value) {
        this.arg3Scalar = value;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.arg1Column + ", val " + this.arg2Scalar + ", val " + this.arg3Scalar;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("double"), VectorExpressionDescriptor.ArgumentType.getType("long")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

