/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IdentityExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public abstract class VectorExpression
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected VectorExpression[] childExpressions = null;
    protected Type[] inputTypes;
    protected TypeInfo outputTypeInfo;

    public abstract void evaluate(VectorizedRowBatch var1) throws HiveException;

    public abstract int getOutputColumn();

    public TypeInfo getOutputTypeInfo() {
        return this.outputTypeInfo;
    }

    public void setOutputTypeInfo(TypeInfo outputTypeInfo) {
        this.outputTypeInfo = outputTypeInfo;
    }

    public void setChildExpressions(VectorExpression[] ve) {
        this.childExpressions = ve;
    }

    public VectorExpression[] getChildExpressions() {
        return this.childExpressions;
    }

    public abstract VectorExpressionDescriptor.Descriptor getDescriptor();

    protected final void evaluateChildren(VectorizedRowBatch vrg) throws HiveException {
        if (this.childExpressions != null) {
            for (VectorExpression ve : this.childExpressions) {
                ve.evaluate(vrg);
            }
        }
    }

    protected String getColumnParamString(int typeNum, int columnNum) {
        return "col " + columnNum + ":" + this.getParamTypeString(typeNum);
    }

    protected String getParamTypeString(int typeNum) {
        if (this.inputTypes == null) {
            return "<input types is null>";
        }
        return this.inputTypes[typeNum].toString();
    }

    public void setInputTypes(Type ... inputTypes) {
        this.inputTypes = inputTypes;
    }

    public Type[] getInputTypes() {
        return this.inputTypes;
    }

    public String vectorExpressionParameters() {
        return null;
    }

    public boolean supportsCheckedExecution() {
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this instanceof IdentityExpression) {
            b.append(this.vectorExpressionParameters());
        } else {
            int outputColumn;
            b.append(this.getClass().getSimpleName());
            String vectorExpressionParameters = this.vectorExpressionParameters();
            if (vectorExpressionParameters != null) {
                b.append("(");
                b.append(vectorExpressionParameters);
                b.append(")");
            }
            if (this.childExpressions != null) {
                b.append("(children: ");
                for (int i = 0; i < this.childExpressions.length; ++i) {
                    b.append(this.childExpressions[i].toString());
                    if (i >= this.childExpressions.length - 1) continue;
                    b.append(", ");
                }
                b.append(")");
            }
            if ((outputColumn = this.getOutputColumn()) != -1) {
                b.append(" -> ");
                b.append(outputColumn);
                b.append(":");
                b.append(this.getOutputTypeInfo());
            }
        }
        return b.toString();
    }

    public static String displayUtf8Bytes(byte[] bytes) {
        if (bytes == null) {
            return "NULL";
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String displayArrayOfUtf8ByteArrays(byte[][] arrayOfByteArrays) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (byte[] bytes : arrayOfByteArrays) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(VectorExpression.displayUtf8Bytes(bytes));
        }
        return sb.toString();
    }

    public static enum Type {
        STRING,
        CHAR,
        VARCHAR,
        TIMESTAMP,
        DATE,
        LONG,
        DOUBLE,
        DECIMAL,
        INTERVAL_YEAR_MONTH,
        INTERVAL_DAY_TIME,
        OTHER;

        private static Map<String, Type> types;

        public static Type getValue(String name) {
            String nameLower = name.toLowerCase();
            if (types.containsKey(nameLower)) {
                return types.get(nameLower);
            }
            return OTHER;
        }

        static {
            types = ImmutableMap.builder().put("string", STRING).put("char", CHAR).put("varchar", VARCHAR).put("timestamp", TIMESTAMP).put("date", DATE).put("long", LONG).put("double", DOUBLE).put("decimal", DECIMAL).put("interval_year_month", INTERVAL_YEAR_MONTH).put("interval_day_time", INTERVAL_DAY_TIME).build();
        }
    }
}

