/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class LongScalarDivideLongColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private double value;
    private int outputColumn;

    public LongScalarDivideLongColumn(long value, int colNum, int outputColumn) {
        this();
        this.colNum = colNum;
        this.value = value;
        this.outputColumn = outputColumn;
    }

    public LongScalarDivideLongColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector = (LongColumnVector)batch.cols[this.colNum];
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        int n = batch.size;
        long[] vector = inputColVector.vector;
        double[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        boolean hasDivBy0 = false;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                long denom = vector[0];
                outputVector[0] = this.value / (double)denom;
                hasDivBy0 = hasDivBy0 || denom == 0L;
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
        } else if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        long denom = vector[i];
                        outputVector[i] = this.value / (double)denom;
                        hasDivBy0 = hasDivBy0 || denom == 0L;
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        long denom = vector[i];
                        outputVector[i] = this.value / (double)denom;
                        hasDivBy0 = hasDivBy0 || denom == 0L;
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    long denom = vector[i];
                    outputVector[i] = this.value / (double)denom;
                    hasDivBy0 = hasDivBy0 || denom == 0L;
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    long denom = vector[i];
                    outputVector[i] = this.value / (double)denom;
                    hasDivBy0 = hasDivBy0 || denom == 0L;
                    outputIsNull[i] = inputIsNull[i];
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    long denom = vector[i];
                    outputVector[i] = this.value / (double)denom;
                    hasDivBy0 = hasDivBy0 || denom == 0L;
                }
            }
        }
        if (!hasDivBy0) {
            NullUtil.setNullDataEntriesDouble(outputColVector, batch.selectedInUse, sel, n);
        } else {
            NullUtil.setNullAndDivBy0DataEntriesDouble(outputColVector, batch.selectedInUse, sel, n, inputColVector);
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "val " + this.value + ", col " + this.colNum;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.INT_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

