/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;

public class LimitOperator
extends Operator<LimitDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient int limit;
    protected transient int offset;
    protected transient int leastRow;
    protected transient int currCount;
    protected transient boolean isMap;

    protected LimitOperator() {
    }

    public LimitOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.limit = ((LimitDesc)this.conf).getLimit();
        this.leastRow = ((LimitDesc)this.conf).getLeastRows();
        this.offset = ((LimitDesc)this.conf).getOffset() == null ? 0 : ((LimitDesc)this.conf).getOffset();
        this.currCount = 0;
        this.isMap = hconf.getBoolean("mapred.task.is.map", true);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        if (this.offset <= this.currCount && this.currCount < this.offset + this.limit) {
            this.forward(row, this.inputObjInspectors[tag]);
            ++this.currCount;
        } else if (this.offset > this.currCount) {
            ++this.currCount;
        } else {
            this.setDone(true);
        }
    }

    @Override
    public String getName() {
        return LimitOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "LIM";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.LIMIT;
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (!this.isMap && this.currCount < this.leastRow) {
            throw new HiveException("No sufficient row found");
        }
    }
}

