/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.LineageState;

public class QueryState {
    private final HiveConf queryConf;
    private HiveOperation commandType;
    private LineageState lineageState = new LineageState();
    private long numModifiedRows = 0L;

    public QueryState(HiveConf conf) {
        this(conf, null, false);
    }

    public QueryState(HiveConf conf, LineageState lineage) {
        this(conf, null, false, lineage);
    }

    public QueryState(HiveConf conf, Map<String, String> confOverlay, boolean runAsync) {
        this(conf, confOverlay, runAsync, new LineageState());
    }

    public QueryState(HiveConf conf, Map<String, String> confOverlay, boolean runAsync, LineageState lineage) {
        this.queryConf = this.createConf(conf, confOverlay, runAsync);
        this.lineageState = lineage;
    }

    private HiveConf createConf(HiveConf conf, Map<String, String> confOverlay, boolean runAsync) {
        if (confOverlay != null && !confOverlay.isEmpty()) {
            conf = conf == null ? new HiveConf() : new HiveConf(conf);
            for (Map.Entry<String, String> confEntry : confOverlay.entrySet()) {
                try {
                    conf.verifyAndSet(confEntry.getKey(), confEntry.getValue());
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Error applying statement specific settings", e);
                }
            }
        } else if (runAsync) {
            HiveConf hiveConf = conf = conf == null ? new HiveConf() : new HiveConf(conf);
        }
        if (conf == null) {
            conf = new HiveConf();
        }
        conf.setVar(HiveConf.ConfVars.HIVEQUERYID, QueryPlan.makeQueryId());
        return conf;
    }

    public String getQueryId() {
        return this.queryConf.getVar(HiveConf.ConfVars.HIVEQUERYID);
    }

    public String getQueryString() {
        return this.queryConf.getQueryString();
    }

    public String getCommandType() {
        if (this.commandType == null) {
            return null;
        }
        return this.commandType.getOperationName();
    }

    public HiveOperation getHiveOperation() {
        return this.commandType;
    }

    public void setCommandType(HiveOperation commandType) {
        this.commandType = commandType;
    }

    public HiveConf getConf() {
        return this.queryConf;
    }

    public LineageState getLineageState() {
        return this.lineageState;
    }

    public void setLineageState(LineageState lineageState) {
        this.lineageState = lineageState;
    }

    public long getNumModifiedRows() {
        return this.numModifiedRows;
    }

    public void setNumModifiedRows(long numModifiedRows) {
        this.numModifiedRows = numModifiedRows;
    }

    public static class Builder {
        private Map<String, String> confOverlay = null;
        private boolean isolated = true;
        private boolean generateNewQueryId = false;
        private HiveConf hiveConf = null;
        private LineageState lineageState = null;

        public Builder withConfOverlay(Map<String, String> confOverlay) {
            this.confOverlay = confOverlay;
            return this;
        }

        public Builder nonIsolated() {
            this.isolated = false;
            return this;
        }

        public Builder withGenerateNewQueryId(boolean generateNewQueryId) {
            this.generateNewQueryId = generateNewQueryId;
            return this;
        }

        public Builder withHiveConf(HiveConf hiveConf) {
            this.hiveConf = hiveConf;
            return this;
        }

        public Builder withLineageState(LineageState lineageState) {
            this.lineageState = lineageState;
            return this;
        }

        public QueryState build() {
            HiveConf queryConf = this.isolated ? (this.hiveConf == null ? new HiveConf() : new HiveConf(this.hiveConf)) : this.hiveConf;
            if (this.confOverlay != null && !this.confOverlay.isEmpty()) {
                for (Map.Entry<String, String> confEntry : this.confOverlay.entrySet()) {
                    try {
                        queryConf.verifyAndSet(confEntry.getKey(), confEntry.getValue());
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException("Error applying statement specific settings", e);
                    }
                }
            }
            if (this.generateNewQueryId) {
                String queryId = QueryPlan.makeQueryId();
                queryConf.setVar(HiveConf.ConfVars.HIVEQUERYID, queryId);
                if (this.hiveConf != null) {
                    this.hiveConf.setVar(HiveConf.ConfVars.HIVEQUERYID, queryId);
                }
            }
            QueryState queryState = new QueryState(queryConf);
            if (this.lineageState != null) {
                queryState.setLineageState(this.lineageState);
            }
            return queryState;
        }
    }
}

