/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hadoop.hive.ql.QueryState;

public class DriverFactory {
    public static IDriver newDriver(HiveConf conf) {
        return DriverFactory.newDriver(DriverFactory.getNewQueryState(conf), null, null);
    }

    public static IDriver newDriver(QueryState queryState, String userName, QueryInfo queryInfo) {
        ExecutionStrategy strategy = ExecutionStrategy.none;
        return strategy.build(queryState, userName, queryInfo);
    }

    private static QueryState getNewQueryState(HiveConf conf) {
        return new QueryState.Builder().withGenerateNewQueryId(true).withHiveConf(conf).build();
    }

    static enum ExecutionStrategy {
        none{

            @Override
            IDriver build(QueryState queryState, String userName, QueryInfo queryInfo) {
                return new Driver(queryState, userName, queryInfo);
            }
        };


        abstract IDriver build(QueryState var1, String var2, QueryInfo var3);
    }
}

