/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.AddPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateTableMessage;
import org.apache.hadoop.hive.metastore.messaging.DropDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.DropFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.DropIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.DropPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.DropTableMessage;
import org.apache.hadoop.hive.metastore.messaging.InsertMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAddPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAlterDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAlterIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAlterPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAlterTableMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONCreateDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONCreateFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONCreateIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONCreateTableMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropTableMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONInsertMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TJSONProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONMessageFactory
extends MessageFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)JSONMessageFactory.class.getName());
    private static JSONMessageDeserializer deserializer = new JSONMessageDeserializer();
    public static final boolean ADD_THRIFT_OBJECT = HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.METASTORE_NOTIFICATIONS_ADD_THRIFT_OBJECTS);
    static List<Predicate<String>> paramsFilter;

    @Override
    public void init() throws MetaException {
        super.init();
        List<String> excludePatterns = Arrays.asList(HiveConf.getTrimmedStringsVar(hiveConf, HiveConf.ConfVars.EVENT_NOTIFICATION_PARAMETERS_EXCLUDE_PATTERNS));
        try {
            paramsFilter = MetaStoreUtils.compilePatternsToPredicates(excludePatterns);
        }
        catch (PatternSyntaxException e) {
            LOG.error("Regex pattern compilation failed. Verify that " + HiveConf.ConfVars.EVENT_NOTIFICATION_PARAMETERS_EXCLUDE_PATTERNS.varname + " has valid patterns.");
            throw new MetaException("Regex pattern compilation failed. " + e.getMessage());
        }
    }

    @Override
    public MessageDeserializer getDeserializer() {
        return deserializer;
    }

    @Override
    public String getVersion() {
        return "0.1";
    }

    @Override
    public String getMessageFormat() {
        return "json";
    }

    @Override
    public CreateDatabaseMessage buildCreateDatabaseMessage(Database db) {
        return new JSONCreateDatabaseMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, db, (Long)this.now());
    }

    @Override
    public AlterDatabaseMessage buildAlterDatabaseMessage(Database beforeDb, Database afterDb) {
        return new JSONAlterDatabaseMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, beforeDb, afterDb, this.now());
    }

    @Override
    public DropDatabaseMessage buildDropDatabaseMessage(Database db) {
        return new JSONDropDatabaseMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, db, this.now());
    }

    @Override
    public CreateTableMessage buildCreateTableMessage(Table table) {
        return new JSONCreateTableMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, this.now());
    }

    @Override
    public AlterTableMessage buildAlterTableMessage(Table before, Table after) {
        return new JSONAlterTableMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, before, after, this.now());
    }

    @Override
    public DropTableMessage buildDropTableMessage(Table table) {
        return new JSONDropTableMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, this.now());
    }

    @Override
    public AddPartitionMessage buildAddPartitionMessage(Table table, Iterator<Partition> partitionsIterator) {
        return new JSONAddPartitionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, partitionsIterator, (Long)this.now());
    }

    @Override
    public AlterPartitionMessage buildAlterPartitionMessage(Table table, Partition before, Partition after) {
        return new JSONAlterPartitionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, before, after, this.now());
    }

    @Override
    public DropPartitionMessage buildDropPartitionMessage(Table table, Iterator<Partition> partitionsIterator) {
        return new JSONDropPartitionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, JSONMessageFactory.getPartitionKeyValues(table, partitionsIterator), this.now());
    }

    @Override
    public CreateFunctionMessage buildCreateFunctionMessage(org.apache.hadoop.hive.metastore.api.Function fn) {
        return new JSONCreateFunctionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, fn, this.now());
    }

    @Override
    public DropFunctionMessage buildDropFunctionMessage(org.apache.hadoop.hive.metastore.api.Function fn) {
        return new JSONDropFunctionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, fn, this.now());
    }

    @Override
    public CreateIndexMessage buildCreateIndexMessage(Index idx) {
        return new JSONCreateIndexMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, idx, this.now());
    }

    @Override
    public DropIndexMessage buildDropIndexMessage(Index idx) {
        return new JSONDropIndexMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, idx, this.now());
    }

    @Override
    public AlterIndexMessage buildAlterIndexMessage(Index before, Index after) {
        return new JSONAlterIndexMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, before, after, this.now());
    }

    @Override
    public InsertMessage buildInsertMessage(Table tableObj, Partition partObj, boolean replace, List<String> files) {
        return new JSONInsertMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, tableObj, partObj, replace, files, this.now());
    }

    private long now() {
        return System.currentTimeMillis() / 1000L;
    }

    static Map<String, String> getPartitionKeyValues(Table table, Partition partition) {
        LinkedHashMap<String, String> partitionKeys = new LinkedHashMap<String, String>();
        for (int i = 0; i < table.getPartitionKeysSize(); ++i) {
            partitionKeys.put(table.getPartitionKeys().get(i).getName(), partition.getValues().get(i));
        }
        return partitionKeys;
    }

    static List<Map<String, String>> getPartitionKeyValues(final Table table, Iterator<Partition> iterator) {
        return Lists.newArrayList(Iterators.transform(iterator, new Function<Partition, Map<String, String>>(){

            @Override
            public Map<String, String> apply(@Nullable Partition partition) {
                return JSONMessageFactory.getPartitionKeyValues(table, partition);
            }
        }));
    }

    static String createTableObjJson(Table tableObj) throws TException {
        if (!ADD_THRIFT_OBJECT) {
            return null;
        }
        MetaStoreUtils.filterMapkeys(tableObj.getParameters(), paramsFilter);
        TSerializer serializer = new TSerializer(new TJSONProtocol.Factory());
        return serializer.toString(tableObj, "UTF-8");
    }

    static String createDatabaseObjJson(Database dbObj) throws TException {
        if (!ADD_THRIFT_OBJECT) {
            return null;
        }
        MetaStoreUtils.filterMapkeys(dbObj.getParameters(), paramsFilter);
        TSerializer serializer = new TSerializer(new TJSONProtocol.Factory());
        return serializer.toString(dbObj, "UTF-8");
    }

    static String createPartitionObjJson(Partition partitionObj) throws TException {
        if (!ADD_THRIFT_OBJECT) {
            return null;
        }
        MetaStoreUtils.filterMapkeys(partitionObj.getParameters(), paramsFilter);
        TSerializer serializer = new TSerializer(new TJSONProtocol.Factory());
        return serializer.toString(partitionObj, "UTF-8");
    }

    static String createFunctionObjJson(org.apache.hadoop.hive.metastore.api.Function functionObj) throws TException {
        if (!ADD_THRIFT_OBJECT) {
            return null;
        }
        TSerializer serializer = new TSerializer(new TJSONProtocol.Factory());
        return serializer.toString(functionObj, "UTF-8");
    }

    static String createIndexObjJson(Index indexObj) throws TException {
        if (!ADD_THRIFT_OBJECT) {
            return null;
        }
        TSerializer serializer = new TSerializer(new TJSONProtocol.Factory());
        return serializer.toString(indexObj, "UTF-8");
    }

    public static ObjectNode getJsonTree(NotificationEvent event) throws Exception {
        JsonParser jsonParser = new JsonFactory().createJsonParser(event.getMessage());
        ObjectMapper mapper = new ObjectMapper();
        return (ObjectNode)mapper.readValue(jsonParser, ObjectNode.class);
    }

    public static Table getTableObj(ObjectNode jsonTree) throws Exception {
        TDeserializer deSerializer = new TDeserializer(new TJSONProtocol.Factory());
        Table tableObj = new Table();
        String tableJson = jsonTree.get("tableObjJson").asText();
        deSerializer.deserialize(tableObj, tableJson, "UTF-8");
        return tableObj;
    }

    public static TBase getTObj(String tSerialized, Class<? extends TBase> objClass) throws Exception {
        if (tSerialized == null) {
            return null;
        }
        TDeserializer thriftDeSerializer = new TDeserializer(new TJSONProtocol.Factory());
        TBase obj = objClass.newInstance();
        thriftDeSerializer.deserialize(obj, tSerialized, "UTF-8");
        return obj;
    }

    public static Iterable<? extends TBase> getTObjs(Iterable<String> objRefStrs, final Class<? extends TBase> objClass) throws Exception {
        try {
            return Iterables.transform(objRefStrs, new Function<String, TBase>(){

                @Override
                public TBase apply(@Nullable String objStr) {
                    try {
                        return JSONMessageFactory.getTObj(objStr, objClass);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException re) {
            Throwable t = re.getCause();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw re;
        }
    }

    public static Iterable<? extends TBase> getTObjs(ObjectNode jsonTree, String objRefListName, Class<? extends TBase> objClass) throws Exception {
        JsonNode jsonArrayIterator = jsonTree.get(objRefListName);
        Function<JsonNode, String> textExtractor = new Function<JsonNode, String>(){

            @Override
            @Nullable
            public String apply(@Nullable JsonNode input) {
                return input.asText();
            }
        };
        return JSONMessageFactory.getTObjs(Iterables.transform(jsonArrayIterator, textExtractor), objClass);
    }

    public static List<Partition> getPartitionObjList(ObjectNode jsonTree) throws Exception {
        TDeserializer deSerializer = new TDeserializer(new TJSONProtocol.Factory());
        ArrayList<Partition> partitionObjList = new ArrayList<Partition>();
        Partition partitionObj = new Partition();
        Iterator jsonArrayIterator = jsonTree.get("partitionListJson").iterator();
        while (jsonArrayIterator.hasNext()) {
            deSerializer.deserialize(partitionObj, ((JsonNode)jsonArrayIterator.next()).asText(), "UTF-8");
            partitionObjList.add(partitionObj);
        }
        return partitionObjList;
    }

    public static org.apache.hadoop.hive.metastore.api.Function getFunctionObj(ObjectNode jsonTree) throws Exception {
        TDeserializer deSerializer = new TDeserializer(new TJSONProtocol.Factory());
        org.apache.hadoop.hive.metastore.api.Function funcObj = new org.apache.hadoop.hive.metastore.api.Function();
        String tableJson = jsonTree.get("functionObjJson").asText();
        deSerializer.deserialize(funcObj, tableJson, "UTF-8");
        return funcObj;
    }

    public static Index getIndexObj(ObjectNode jsonTree) throws Exception {
        return JSONMessageFactory.getIndexObj(jsonTree, "indexObjJson");
    }

    public static Index getIndexObj(ObjectNode jsonTree, String indexObjKey) throws Exception {
        TDeserializer deSerializer = new TDeserializer(new TJSONProtocol.Factory());
        Index indexObj = new Index();
        String tableJson = jsonTree.get(indexObjKey).asText();
        deSerializer.deserialize(indexObj, tableJson, "UTF-8");
        return indexObj;
    }
}

