/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import tachyon.conf.WorkerConf;
import tachyon.worker.BlockHandler;

public final class BlockResponse {
    private final long mBlockId;
    private final long mOffset;
    private final long mLength;
    private final BlockHandler mHandler;

    public static BlockResponse createErrorResponse(long blockId) {
        return new BlockResponse(-blockId, 0L, 0L, null);
    }

    public BlockResponse(long blockId, long offset, long length, BlockHandler handler) {
        this.mBlockId = blockId;
        this.mOffset = offset;
        this.mLength = length;
        this.mHandler = handler;
    }

    public long getBlockId() {
        return this.mBlockId;
    }

    public BlockHandler getHandler() {
        return this.mHandler;
    }

    public long getLength() {
        return this.mLength;
    }

    public long getOffset() {
        return this.mOffset;
    }

    public static final class Encoder
    extends MessageToMessageEncoder<BlockResponse> {
        private static final int MESSAGE_LENGTH = 26;

        private ByteBuf createHeader(ChannelHandlerContext ctx, BlockResponse msg) {
            ByteBuf header = ctx.alloc().buffer(26);
            header.writeShort(2);
            header.writeLong(msg.getBlockId());
            header.writeLong(msg.getOffset());
            header.writeLong(msg.getLength());
            return header;
        }

        protected void encode(ChannelHandlerContext ctx, BlockResponse msg, List<Object> out) throws Exception {
            out.add(this.createHeader(ctx, msg));
            BlockHandler handler = msg.getHandler();
            if (handler != null) {
                switch (WorkerConf.get().NETTY_FILE_TRANSFER_TYPE) {
                    case MAPPED: {
                        ByteBuffer data = handler.read(msg.getOffset(), (int)msg.getLength());
                        out.add(Unpooled.wrappedBuffer((ByteBuffer)data));
                        handler.close();
                        break;
                    }
                    case TRANSFER: {
                        if (handler.getChannel() instanceof FileChannel) {
                            out.add(new DefaultFileRegion((FileChannel)handler.getChannel(), msg.getOffset(), msg.getLength()));
                            break;
                        }
                        handler.close();
                        throw new Exception("Only FileChannel is supported!");
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown file transfer type: " + (Object)((Object)WorkerConf.get().NETTY_FILE_TRANSFER_TYPE)));
                    }
                }
            }
        }
    }
}

