/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker.eviction;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tachyon.Pair;
import tachyon.worker.eviction.EvictLRUBase;
import tachyon.worker.hierarchy.BlockInfo;
import tachyon.worker.hierarchy.StorageDir;

public final class EvictLRU
extends EvictLRUBase {
    public EvictLRU(boolean lastTier) {
        super(lastTier);
    }

    @Override
    public synchronized Pair<StorageDir, List<BlockInfo>> getDirCandidate(StorageDir[] storageDirs, Set<Integer> pinList, long requestBytes) {
        StorageDir dir;
        long evictBytes;
        ArrayList<BlockInfo> blockInfoList = new ArrayList<BlockInfo>();
        HashMap<StorageDir, Pair<Long, Long>> dir2LRUBlocks = new HashMap<StorageDir, Pair<Long, Long>>();
        HashMultimap dir2BlocksToEvict = HashMultimap.create();
        HashMap<StorageDir, Long> sizeToEvict = new HashMap<StorageDir, Long>();
        do {
            Pair<StorageDir, Long> candidate;
            if ((dir = (candidate = this.getLRUBlockCandidate(storageDirs, dir2LRUBlocks, (HashMultimap<StorageDir, Long>)dir2BlocksToEvict, pinList)).getFirst()) == null) {
                return null;
            }
            long blockId = candidate.getSecond();
            long blockSize = dir.getBlockSize(blockId);
            blockInfoList.add(new BlockInfo(dir, blockId, blockSize));
            dir2BlocksToEvict.put((Object)dir, (Object)blockId);
            dir2LRUBlocks.remove(dir);
            evictBytes = sizeToEvict.containsKey(dir) ? (Long)sizeToEvict.get(dir) + blockSize : blockSize;
            sizeToEvict.put(dir, evictBytes);
        } while (evictBytes + dir.getAvailableBytes() < requestBytes);
        return new Pair<StorageDir, List<BlockInfo>>(dir, blockInfoList);
    }

    private Pair<StorageDir, Long> getLRUBlockCandidate(StorageDir[] storageDirs, Map<StorageDir, Pair<Long, Long>> dir2LRUBlocks, HashMultimap<StorageDir, Long> dir2BlocksToEvict, Set<Integer> pinList) {
        StorageDir dirCandidate = null;
        long blockId = -1L;
        long oldestTime = Long.MAX_VALUE;
        for (StorageDir dir : storageDirs) {
            Pair<Long, Long> lruBlock;
            if (!dir2LRUBlocks.containsKey(dir)) {
                Set blocksToEvict = dir2BlocksToEvict.get((Object)dir);
                lruBlock = this.getLRUBlock(dir, blocksToEvict, pinList);
                if (lruBlock.getFirst() == -1L) continue;
                dir2LRUBlocks.put(dir, lruBlock);
            } else {
                lruBlock = dir2LRUBlocks.get(dir);
            }
            if (lruBlock.getSecond() >= oldestTime) continue;
            blockId = lruBlock.getFirst();
            oldestTime = lruBlock.getSecond();
            dirCandidate = dir;
        }
        return new Pair<Object, Long>(dirCandidate, blockId);
    }
}

