/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker;

import java.io.IOException;
import tachyon.org.apache.thrift.TException;
import tachyon.thrift.BlockInfoException;
import tachyon.thrift.FailedToCheckpointException;
import tachyon.thrift.FileAlreadyExistException;
import tachyon.thrift.FileDoesNotExistException;
import tachyon.thrift.OutOfSpaceException;
import tachyon.thrift.SuspectedFileSizeException;
import tachyon.thrift.TachyonException;
import tachyon.thrift.WorkerService;
import tachyon.worker.WorkerStorage;
import tachyon.worker.hierarchy.StorageDir;

public class WorkerServiceHandler
implements WorkerService.Iface {
    private final WorkerStorage mWorkerStorage;

    public WorkerServiceHandler(WorkerStorage workerStorage) {
        this.mWorkerStorage = workerStorage;
    }

    @Override
    public void accessBlock(long blockId) throws TException {
        this.mWorkerStorage.accessBlock(blockId);
    }

    @Override
    public void addCheckpoint(long userId, int fileId) throws FileDoesNotExistException, SuspectedFileSizeException, FailedToCheckpointException, BlockInfoException, TException {
        try {
            this.mWorkerStorage.addCheckpoint(userId, fileId);
        }
        catch (IOException e) {
            throw new TException(e);
        }
    }

    @Override
    public boolean asyncCheckpoint(int fileId) throws TachyonException, TException {
        try {
            return this.mWorkerStorage.asyncCheckpoint(fileId);
        }
        catch (IOException e) {
            throw new TachyonException(e.getMessage());
        }
    }

    @Override
    public void cacheBlock(long userId, long blockId) throws FileDoesNotExistException, SuspectedFileSizeException, BlockInfoException, TException {
        try {
            this.mWorkerStorage.cacheBlock(userId, blockId);
        }
        catch (IOException e) {
            throw new TException(e);
        }
    }

    @Override
    public void cancelBlock(long userId, long blockId) throws TException {
        this.mWorkerStorage.cancelBlock(userId, blockId);
    }

    @Override
    public String getUserUfsTempFolder(long userId) throws TException {
        return this.mWorkerStorage.getUserUfsTempFolder(userId);
    }

    @Override
    public String lockBlock(long blockId, long userId) throws FileDoesNotExistException, TException {
        StorageDir storageDir = this.mWorkerStorage.lockBlock(blockId, userId);
        if (storageDir == null) {
            throw new FileDoesNotExistException("Block file not found! blockId:" + blockId);
        }
        return storageDir.getBlockFilePath(blockId);
    }

    @Override
    public boolean promoteBlock(long blockId) throws TException {
        return this.mWorkerStorage.promoteBlock(blockId);
    }

    @Override
    public String requestBlockLocation(long userId, long blockId, long initialBytes) throws OutOfSpaceException, FileAlreadyExistException, TException {
        return this.mWorkerStorage.requestBlockLocation(userId, blockId, initialBytes);
    }

    @Override
    public boolean requestSpace(long userId, long blockId, long requestBytes) throws FileDoesNotExistException, TException {
        return this.mWorkerStorage.requestSpace(userId, blockId, requestBytes);
    }

    @Override
    public boolean unlockBlock(long blockId, long userId) throws TException {
        return this.mWorkerStorage.unlockBlock(blockId, userId);
    }

    @Override
    public void userHeartbeat(long userId) throws TException {
        this.mWorkerStorage.userHeartbeat(userId);
    }
}

