/*
 * Decompiled with CFR 0.152.
 */
package tachyon;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.UnderFileSystem;
import tachyon.Version;
import tachyon.conf.CommonConf;
import tachyon.conf.MasterConf;
import tachyon.conf.WorkerConf;
import tachyon.util.CommonUtils;

public class Format {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private static final String USAGE = "java -cp target/tachyon-" + Version.VERSION + "-jar-with-dependencies.jar tachyon.Format <MASTER/WORKER>";

    private static boolean formatFolder(String name, String folder) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(folder);
        LOG.info("Formatting {}:{}", (Object)name, (Object)folder);
        if (ufs.exists(folder) && !ufs.delete(folder, true)) {
            LOG.info("Failed to remove {}:{}", (Object)name, (Object)folder);
            return false;
        }
        if (!ufs.mkdirs(folder, true)) {
            LOG.info("Failed to create {}:{}", (Object)name, (Object)folder);
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            LOG.info(USAGE);
            System.exit(-1);
        }
        if (args[0].toUpperCase().equals("MASTER")) {
            MasterConf masterConf = MasterConf.get();
            if (!Format.formatFolder("JOURNAL_FOLDER", masterConf.JOURNAL_FOLDER)) {
                System.exit(-1);
            }
            CommonConf commonConf = CommonConf.get();
            if (!Format.formatFolder("UNDERFS_DATA_FOLDER", commonConf.UNDERFS_DATA_FOLDER) || !Format.formatFolder("UNDERFS_WORKERS_FOLDER", commonConf.UNDERFS_WORKERS_FOLDER)) {
                System.exit(-1);
            }
            CommonUtils.touch(masterConf.JOURNAL_FOLDER + masterConf.FORMAT_FILE_PREFIX + System.currentTimeMillis());
        } else if (args[0].toUpperCase().equals("WORKER")) {
            WorkerConf workerConf = WorkerConf.get();
            for (int level = 0; level < workerConf.STORAGE_LEVELS; ++level) {
                String[] dirPaths = workerConf.STORAGE_TIER_DIRS[level].split(",");
                for (int i = 0; i < dirPaths.length; ++i) {
                    String[] files;
                    String dataPath = CommonUtils.concat(dirPaths[i].trim(), workerConf.DATA_FOLDER);
                    UnderFileSystem ufs = UnderFileSystem.get(dataPath);
                    LOG.info("Removing data under folder: {}", (Object)dataPath);
                    if (!ufs.exists(dataPath)) continue;
                    for (String file : files = ufs.list(dataPath)) {
                        ufs.delete(CommonUtils.concat(dataPath, file), true);
                    }
                }
            }
        } else {
            LOG.info(USAGE);
            System.exit(-1);
        }
    }
}

