/*
 * Decompiled with CFR 0.152.
 */
package tachyon.web;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tachyon.Constants;
import tachyon.Version;
import tachyon.master.DependencyVariables;
import tachyon.master.MasterInfo;
import tachyon.thrift.ClientWorkerInfo;
import tachyon.util.CommonUtils;

public class WebInterfaceGeneralServlet
extends HttpServlet {
    private static final long serialVersionUID = 2335205655766736309L;
    private MasterInfo mMasterInfo;

    public WebInterfaceGeneralServlet(MasterInfo masterInfo) {
        this.mMasterInfo = masterInfo;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.populateValues(request);
        this.getServletContext().getRequestDispatcher("/general.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DependencyVariables.sVariables.clear();
        for (String key : request.getParameterMap().keySet()) {
            String value;
            if (!key.startsWith("varName") || (value = request.getParameter("varVal" + key.substring(7))) == null) continue;
            DependencyVariables.sVariables.put(request.getParameter(key), value);
        }
        this.populateValues(request);
        this.getServletContext().getRequestDispatcher("/general.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void populateValues(HttpServletRequest request) throws IOException {
        request.setAttribute("debug", (Object)Constants.DEBUG);
        request.setAttribute("masterNodeAddress", (Object)this.mMasterInfo.getMasterAddress().toString());
        request.setAttribute("uptime", (Object)CommonUtils.convertMsToClockTime(System.currentTimeMillis() - this.mMasterInfo.getStarttimeMs()));
        request.setAttribute("startTime", (Object)CommonUtils.convertMsToDate(this.mMasterInfo.getStarttimeMs()));
        request.setAttribute("version", (Object)Version.VERSION);
        request.setAttribute("liveWorkerNodes", (Object)Integer.toString(this.mMasterInfo.getWorkerCount()));
        request.setAttribute("capacity", (Object)CommonUtils.getSizeFromBytes(this.mMasterInfo.getCapacityBytes()));
        request.setAttribute("usedCapacity", (Object)CommonUtils.getSizeFromBytes(this.mMasterInfo.getUsedBytes()));
        request.setAttribute("freeCapacity", (Object)CommonUtils.getSizeFromBytes(this.mMasterInfo.getCapacityBytes() - this.mMasterInfo.getUsedBytes()));
        long sizeBytes = this.mMasterInfo.getUnderFsCapacityBytes();
        if (sizeBytes >= 0L) {
            request.setAttribute("diskCapacity", (Object)CommonUtils.getSizeFromBytes(sizeBytes));
        } else {
            request.setAttribute("diskCapacity", (Object)"UNKNOWN");
        }
        sizeBytes = this.mMasterInfo.getUnderFsUsedBytes();
        if (sizeBytes >= 0L) {
            request.setAttribute("diskUsedCapacity", (Object)CommonUtils.getSizeFromBytes(sizeBytes));
        } else {
            request.setAttribute("diskUsedCapacity", (Object)"UNKNOWN");
        }
        sizeBytes = this.mMasterInfo.getUnderFsFreeBytes();
        if (sizeBytes >= 0L) {
            request.setAttribute("diskFreeCapacity", (Object)CommonUtils.getSizeFromBytes(sizeBytes));
        } else {
            request.setAttribute("diskFreeCapacity", (Object)"UNKNOWN");
        }
        request.setAttribute("recomputeVariables", DependencyVariables.sVariables);
        List<ClientWorkerInfo> workerInfos = this.mMasterInfo.getWorkersInfo();
        for (int i = 0; i < workerInfos.size(); ++i) {
            for (int j = i + 1; j < workerInfos.size(); ++j) {
                if (workerInfos.get(i).getAddress().getMHost().compareTo(workerInfos.get(j).getAddress().getMHost()) <= 0) continue;
                ClientWorkerInfo temp = workerInfos.get(i);
                workerInfos.set(i, workerInfos.get(j));
                workerInfos.set(j, temp);
            }
        }
        int index = 0;
        NodeInfo[] nodeInfos = new NodeInfo[workerInfos.size()];
        for (ClientWorkerInfo workerInfo : workerInfos) {
            nodeInfos[index++] = new NodeInfo(workerInfo);
        }
        request.setAttribute("nodeInfos", (Object)nodeInfos);
    }

    public class NodeInfo {
        private final String NAME;
        private final String LAST_CONTACT_SEC;
        private final String STATE;
        private final int FREE_SPACE_PERCENT;
        private final int USED_SPACE_PERCENT;
        private final String UPTIME_CLOCK_TIME;

        private NodeInfo(ClientWorkerInfo workerInfo) {
            this.NAME = workerInfo.getAddress().getMHost();
            this.LAST_CONTACT_SEC = Integer.toString(workerInfo.getLastContactSec());
            this.STATE = workerInfo.getState();
            this.USED_SPACE_PERCENT = (int)(100L * workerInfo.getUsedBytes() / workerInfo.getCapacityBytes());
            this.FREE_SPACE_PERCENT = 100 - this.USED_SPACE_PERCENT;
            this.UPTIME_CLOCK_TIME = CommonUtils.convertMsToShortClockTime(System.currentTimeMillis() - workerInfo.getStarttimeMs());
        }

        public int getFreeSpacePercent() {
            return this.FREE_SPACE_PERCENT;
        }

        public String getLastHeartbeat() {
            return this.LAST_CONTACT_SEC;
        }

        public String getName() {
            return this.NAME;
        }

        public String getState() {
            return this.STATE;
        }

        public String getUptimeClockTime() {
            return this.UPTIME_CLOCK_TIME;
        }

        public int getUsedSpacePercent() {
            return this.USED_SPACE_PERCENT;
        }
    }
}

