/*
 * Decompiled with CFR 0.152.
 */
package tachyon.util;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.PrefixList;
import tachyon.UnderFileSystem;
import tachyon.Version;
import tachyon.client.TachyonFS;
import tachyon.org.apache.thrift.TException;
import tachyon.thrift.FileAlreadyExistException;
import tachyon.thrift.FileDoesNotExistException;
import tachyon.thrift.InvalidPathException;
import tachyon.thrift.SuspectedFileSizeException;

public class UnderfsUtil {
    private static Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);

    public static void getInfo(TachyonFS tfs, String underfsAddress, String rootPath, PrefixList excludePathPrefix) throws IOException {
        LOG.info((Object)(tfs + " " + underfsAddress + " " + rootPath + " " + excludePathPrefix));
        Configuration tConf = new Configuration();
        tConf.set("fs.default.name", underfsAddress + rootPath);
        UnderFileSystem fs = UnderFileSystem.get(underfsAddress);
        LinkedList<String> pathQueue = new LinkedList<String>();
        if (excludePathPrefix.outList(rootPath)) {
            pathQueue.add(underfsAddress + rootPath);
        }
        while (!pathQueue.isEmpty()) {
            String filePath;
            String path = (String)pathQueue.poll();
            if (fs.isFile(path)) {
                String filePath2 = path.substring(underfsAddress.length());
                if (tfs.exist(filePath2)) {
                    LOG.info((Object)("File " + filePath2 + " already exists in Tachyon."));
                    continue;
                }
                int fileId = tfs.createFile(filePath2, path);
                if (fileId == -1) {
                    LOG.info((Object)("Failed to create tachyon file: " + filePath2));
                    continue;
                }
                LOG.info((Object)("Create tachyon file " + filePath2 + " with file id " + fileId + " and " + "checkpoint location " + path));
                continue;
            }
            String[] files = fs.list(path);
            if (files != null) {
                for (String filePath3 : files) {
                    LOG.info((Object)("Get: " + filePath3));
                    if (!excludePathPrefix.outList(filePath3)) continue;
                    pathQueue.add(underfsAddress + filePath3);
                }
            }
            if (tfs.exist(filePath = path.substring(underfsAddress.length()))) continue;
            tfs.mkdir(filePath);
        }
    }

    public static void main(String[] args) throws SuspectedFileSizeException, InvalidPathException, IOException, FileDoesNotExistException, FileAlreadyExistException, TException {
        if (args.length != 3 && args.length != 4) {
            String prefix = "java -cp target/tachyon-" + Version.VERSION + "-jar-with-dependencies.jar " + "tachyon.util.UnderfsUtil ";
            System.out.println("Usage: " + prefix + "<TachyonAddress> <UnderfsAddress> <Path> " + "[<ExcludePathPrefix, separated by ;>]");
            System.out.println("Example: " + prefix + "tachyon://127.0.0.1:19998 hdfs://localhost:9000 / /tachyon");
            System.exit(-1);
        }
        PrefixList tExcludePathPrefix = null;
        tExcludePathPrefix = args.length == 4 ? new PrefixList(args[3], ";") : new PrefixList(null);
        UnderfsUtil.getInfo(TachyonFS.get(args[0]), args[1], args[2], tExcludePathPrefix);
        System.exit(0);
    }
}

