/*
 * Decompiled with CFR 0.152.
 */
package tachyon.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Scanner;
import org.apache.log4j.Logger;
import tachyon.UnderFileSystem;
import tachyon.thrift.InvalidPathException;

public final class CommonUtils {
    private static final Logger LOG = Logger.getLogger((String)"");

    private CommonUtils() {
    }

    public static String cleanPath(String path) throws IOException {
        if (path == null || path.isEmpty()) {
            throw new IOException("Path (" + path + ") is invalid.");
        }
        while (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static ByteBuffer cloneByteBuffer(ByteBuffer buf) {
        ByteBuffer ret = ByteBuffer.allocate(buf.limit() - buf.position());
        ret.put(buf.array(), buf.position(), buf.limit() - buf.position());
        ret.flip();
        return ret;
    }

    public static List<ByteBuffer> cloneByteBufferList(List<ByteBuffer> source) {
        ArrayList<ByteBuffer> ret = new ArrayList<ByteBuffer>(source.size());
        for (int k = 0; k < source.size(); ++k) {
            ret.add(CommonUtils.cloneByteBuffer(source.get(k)));
        }
        return ret;
    }

    public static String convertByteArrayToStringWithoutEscape(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length);
        for (int i = 0; i < data.length; ++i) {
            if (data[i] >= 128) {
                return null;
            }
            sb.append((char)data[i]);
        }
        return sb.toString();
    }

    public static String convertMsToClockTime(long Millis) {
        long days = Millis / 86400000L;
        long hours = Millis % 86400000L / 3600000L;
        long mins = Millis % 3600000L / 60000L;
        long secs = Millis % 60000L / 1000L;
        return String.format("%d day(s), %d hour(s), %d minute(s), and %d second(s)", days, hours, mins, secs);
    }

    public static String convertMsToShortClockTime(long Millis) {
        long days = Millis / 86400000L;
        long hours = Millis % 86400000L / 3600000L;
        long mins = Millis % 3600000L / 60000L;
        long secs = Millis % 60000L / 1000L;
        return String.format("%d d, %d h, %d m, and %d s", days, hours, mins, secs);
    }

    public static String convertMsToDate(long Millis) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss:SSS");
        return formatter.format(new Date(Millis));
    }

    public static String convertMsToSimpleDate(long Millis) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM-dd-yyyy");
        return formatter.format(new Date(Millis));
    }

    public static ByteBuffer generateNewByteBufferFromThriftRPCResults(ByteBuffer data) {
        ByteBuffer correctData = ByteBuffer.allocate(data.limit() - data.position());
        correctData.put(data);
        correctData.flip();
        return correctData;
    }

    public static long getCurrentMs() {
        return System.currentTimeMillis();
    }

    public static long getCurrentNs() {
        return System.nanoTime();
    }

    public static long getBlockIdFromFileName(String name) {
        long fileId;
        try {
            fileId = Long.parseLong(name);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Wrong file name: " + name);
        }
        return fileId;
    }

    public static long getMB(long bytes) {
        return bytes / 0x100000L;
    }

    public static String getSizeFromBytes(long bytes) {
        double ret = bytes;
        if (ret <= 5120.0) {
            return String.format("%.2f B", ret);
        }
        if ((ret /= 1024.0) <= 5120.0) {
            return String.format("%.2f KB", ret);
        }
        if ((ret /= 1024.0) <= 5120.0) {
            return String.format("%.2f MB", ret);
        }
        return String.format("%.2f GB", ret /= 1024.0);
    }

    public static void illegalArgumentException(String msg) {
        throw new IllegalArgumentException(msg);
    }

    public static void illegalArgumentException(Exception e) {
        LOG.error((Object)e.getMessage(), (Throwable)e);
        throw new IllegalArgumentException(e);
    }

    public static <T> String listToString(List<T> list) {
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < list.size(); ++k) {
            sb.append(list.get(k)).append(" ");
        }
        return sb.toString();
    }

    public static String parametersToString(Object ... objs) {
        StringBuilder sb = new StringBuilder("(");
        for (int k = 0; k < objs.length; ++k) {
            if (k != 0) {
                sb.append(", ");
            }
            sb.append(objs[k].toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public static long parseMemorySize(String memorySize) {
        int tIndex;
        double alpha = 1.0E-4;
        String ori = memorySize;
        String end = "";
        for (tIndex = memorySize.length() - 1; tIndex >= 0 && (memorySize.charAt(tIndex) > '9' || memorySize.charAt(tIndex) < '0'); --tIndex) {
            end = memorySize.charAt(tIndex) + end;
        }
        memorySize = memorySize.substring(0, tIndex + 1);
        double ret = Double.parseDouble(memorySize);
        if ((end = end.toLowerCase()).isEmpty() || end.equals("b")) {
            return (long)(ret + alpha);
        }
        if (end.equals("kb")) {
            return (long)(ret * 1024.0 + alpha);
        }
        if (end.equals("mb")) {
            return (long)(ret * 1048576.0 + alpha);
        }
        if (end.equals("gb")) {
            return (long)(ret * 1.073741824E9 + alpha);
        }
        if (end.equals("tb")) {
            return (long)(ret * 1.099511627776E12 + alpha);
        }
        CommonUtils.runtimeException("Fail to parse " + ori + " as memory size");
        return -1L;
    }

    public static void printByteBuffer(Logger LOG, ByteBuffer buf) {
        String tmp = "";
        for (int k = 0; k < buf.limit() / 4; ++k) {
            tmp = tmp + buf.getInt() + " ";
        }
        LOG.info((Object)tmp);
    }

    public static void printTimeTakenMs(long startTimeMs, Logger logger, String message) {
        logger.info((Object)(message + " took " + (CommonUtils.getCurrentMs() - startTimeMs) + " ms."));
    }

    public static void printTimeTakenNs(long startTimeNs, Logger logger, String message) {
        logger.info((Object)(message + " took " + (CommonUtils.getCurrentNs() - startTimeNs) + " ns."));
    }

    public static void runtimeException(String msg) {
        throw new RuntimeException(msg);
    }

    public static void runtimeException(Exception e) {
        LOG.error((Object)e.getMessage(), (Throwable)e);
        throw new RuntimeException(e);
    }

    public static void sleepMs(Logger logger, long timeMs) {
        try {
            Thread.sleep(timeMs);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static String[] toStringArray(ArrayList<String> src) {
        String[] ret = new String[src.size()];
        return src.toArray(ret);
    }

    public static void tempoaryLog(String msg) {
        LOG.info((Object)("Temporary Log ============================== " + msg));
    }

    public static void validatePath(String path) throws InvalidPathException {
        if (path == null || !path.startsWith("/") || path.length() > 1 && path.endsWith("/") || path.contains(" ")) {
            throw new InvalidPathException("Path " + path + " is invalid.");
        }
    }

    public static InetSocketAddress parseInetSocketAddress(String address) throws IOException {
        if (address == null) {
            return null;
        }
        String[] strArr = address.split(":");
        if (strArr.length != 2) {
            throw new IOException("Invalid InetSocketAddress " + address);
        }
        return new InetSocketAddress(strArr[0], Integer.parseInt(strArr[1]));
    }

    public static void changeLocalFileToFullPermission(String filePath) throws IOException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("/bin/chmod");
        commands.add("777");
        File file = new File(filePath);
        commands.add(file.getAbsolutePath());
        try {
            ProcessBuilder builder = new ProcessBuilder(commands);
            Process process = builder.start();
            CommonUtils.redirectStreamAsync(process.getInputStream(), System.out);
            CommonUtils.redirectStreamAsync(process.getErrorStream(), System.err);
            process.waitFor();
            if (process.exitValue() != 0) {
                throw new IOException("Can not change the permission of the following file to '777':" + file.getAbsolutePath());
            }
        }
        catch (InterruptedException e) {
            LOG.error((Object)e.getMessage());
            throw new IOException(e);
        }
    }

    static void redirectStreamAsync(final InputStream input, final PrintStream output) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Scanner scanner = new Scanner(input);
                while (scanner.hasNextLine()) {
                    output.println(scanner.nextLine());
                }
                scanner.close();
            }
        }).start();
    }

    public static void setLocalFileStickyBit(String file) {
        try {
            if (file.startsWith("/")) {
                Runtime.getRuntime().exec("chmod o+t " + file);
            }
        }
        catch (IOException e) {
            LOG.info((Object)("Can not set the sticky bit of the file : " + file));
        }
    }

    public static void touch(String path) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(path);
        OutputStream os = ufs.create(path);
        os.close();
    }

    public static boolean mkdirs(String path) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(path);
        return ufs.mkdirs(path, true);
    }
}

