/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import java.nio.ByteBuffer;
import tachyon.master.InodeFolder;
import tachyon.master.InodeType;
import tachyon.thrift.TachyonException;

public class InodeRawTable
extends InodeFolder {
    protected final int COLUMNS;
    private ByteBuffer mMetadata;

    public InodeRawTable(String name, int id, int parentId, int columns, ByteBuffer metadata, long creationTimeMs) throws TachyonException {
        super(name, id, parentId, InodeType.RawTable, creationTimeMs);
        this.COLUMNS = columns;
        this.updateMetadata(metadata);
    }

    public int getColumns() {
        return this.COLUMNS;
    }

    public synchronized void updateMetadata(ByteBuffer metadata) throws TachyonException {
        if (metadata == null) {
            this.mMetadata = ByteBuffer.allocate(0);
        } else {
            if (metadata.limit() - metadata.position() >= 0x500000) {
                throw new TachyonException("Too big table metadata: " + metadata.toString());
            }
            this.mMetadata = ByteBuffer.allocate(metadata.limit() - metadata.position());
            this.mMetadata.put(metadata.array(), metadata.position(), metadata.limit() - metadata.position());
            this.mMetadata.flip();
        }
    }

    public synchronized ByteBuffer getMetadata() {
        ByteBuffer ret = ByteBuffer.allocate(this.mMetadata.capacity());
        ret.put(this.mMetadata.array());
        ret.flip();
        return ret;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("InodeRawTable(");
        sb.append(super.toString()).append(",").append(this.COLUMNS).append(",");
        sb.append(this.mMetadata).append(")");
        return sb.toString();
    }
}

