/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import java.io.IOException;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.UnderFileSystem;
import tachyon.master.Journal;
import tachyon.master.MasterInfo;
import tachyon.util.CommonUtils;

public class EditLogProcessor
implements Runnable {
    private static final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private Journal mJournal;
    private String mPath;
    private MasterInfo mMasterInfo;
    private int mCurrentLogFileNum = 0;
    private int mLastImageFileNum = 0;
    private long mLoadedImageModTime = 0L;
    private boolean mIsStandby = true;

    public EditLogProcessor(Journal journal, String path, MasterInfo info) {
        this.mJournal = journal;
        this.mPath = path;
        this.mMasterInfo = info;
        try {
            this.mLoadedImageModTime = this.mJournal.getImageModTime();
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
        LOG.info((Object)("Created edit log processor with path " + this.mPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.info((Object)("Edit log processor with path " + this.mPath + " started."));
        UnderFileSystem ufs = UnderFileSystem.get(this.mPath);
        while (this.mIsStandby) {
            try {
                Journal journal = this.mJournal;
                synchronized (journal) {
                    long lastImageModTime = this.mJournal.getImageModTime();
                    if (this.mLoadedImageModTime != lastImageModTime) {
                        LOG.info((Object)"The last loaded image is out of date. Loading updated image.");
                        LOG.info((Object)("Loaded image modification time was: " + this.mLoadedImageModTime));
                        LOG.info((Object)("Last image mod time was: " + lastImageModTime));
                        this.mJournal.loadImage(this.mMasterInfo);
                        LOG.info((Object)"Finished loading new image.");
                        this.mLoadedImageModTime = lastImageModTime;
                        this.mCurrentLogFileNum = 0;
                        this.mLastImageFileNum = 0;
                    }
                    String path = this.mPath + "completed/" + this.mCurrentLogFileNum + ".editLog";
                    while (ufs.exists(path)) {
                        LOG.info((Object)("Found completed log file " + path));
                        this.mJournal.loadSingleLogFile(this.mMasterInfo, path);
                        LOG.info((Object)("Finished loading log file " + path));
                        ++this.mCurrentLogFileNum;
                        path = this.mPath + "completed/" + this.mCurrentLogFileNum + ".editLog";
                    }
                    LOG.info((Object)("Edit log with " + path + " was not found."));
                    if (this.mLastImageFileNum != this.mCurrentLogFileNum) {
                        LOG.info((Object)("Last image was updated with log number: " + this.mLastImageFileNum + " writing new image up to log number " + this.mCurrentLogFileNum));
                        this.mJournal.createImage(this.mMasterInfo, this.mPath + this.mMasterInfo.getMasterAddress().getHostName() + this.mMasterInfo.getMasterAddress().getPort() + "/standby.image");
                        LOG.info((Object)"Finished creating image");
                        this.mLastImageFileNum = this.mCurrentLogFileNum;
                    }
                }
                CommonUtils.sleepMs(LOG, 1000L);
            }
            catch (IOException e) {
                CommonUtils.runtimeException(e);
            }
        }
        LOG.info((Object)("Standy log processor with path " + this.mPath + " stopped."));
    }

    public void stop() {
        LOG.info((Object)("Stopping standby log processor with path " + this.mPath));
        this.mIsStandby = false;
    }
}

