/*
 * Decompiled with CFR 0.152.
 */
package tachyon.examples;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.Version;
import tachyon.client.OutStream;
import tachyon.client.TachyonByteBuffer;
import tachyon.client.TachyonFS;
import tachyon.client.TachyonFile;
import tachyon.client.WriteType;
import tachyon.conf.UserConf;
import tachyon.util.CommonUtils;

public class Performance {
    private static Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private static final int RESULT_ARRAY_SIZE = 64;
    private static final String FOLDER = "/mnt/ramdisk/";
    private static TachyonFS MTC = null;
    private static String MASTER_ADDRESS = null;
    private static String FILE_NAME = null;
    private static int BLOCK_SIZE_BYTES = -1;
    private static long BLOCKS_PER_FILE = -1L;
    private static int THREADS = -1;
    private static int FILES = -1;
    private static boolean DEBUG_MODE = false;
    private static long FILE_BYTES = -1L;
    private static long FILES_BYTES = -1L;
    private static String RESULT_PREFIX = null;
    private static long[] Results = new long[64];
    private static int BASE_FILE_NUMBER = 0;

    public static void createFiles() throws IOException {
        long startTimeMs = CommonUtils.getCurrentMs();
        for (int k = 0; k < THREADS; ++k) {
            int fileId = MTC.createFile(FILE_NAME + (k + BASE_FILE_NUMBER));
            CommonUtils.printTimeTakenMs(startTimeMs, LOG, "user_createFiles with fileId " + fileId);
        }
    }

    public static void logPerIteration(long startTimeMs, int times, String msg, int workerId) {
        long takenTimeMs = System.currentTimeMillis() - startTimeMs;
        double result = 1000L * FILE_BYTES / takenTimeMs / 1024L / 1024L;
        LOG.info((Object)(times + msg + workerId + " : " + result + " Mb/sec. Took " + takenTimeMs + " ms. "));
    }

    private static void memoryCopyTest(boolean write, boolean memoryOnly) {
        int thread;
        ByteBuffer[] bufs = new ByteBuffer[THREADS];
        for (int thread2 = 0; thread2 < THREADS; ++thread2) {
            ByteBuffer sRawData = ByteBuffer.allocate(BLOCK_SIZE_BYTES);
            sRawData.order(ByteOrder.nativeOrder());
            for (int k = 0; k < BLOCK_SIZE_BYTES / 4; ++k) {
                sRawData.putInt(k);
            }
            bufs[thread2] = sRawData;
        }
        String msg = (write ? "Write" : "Read") + (memoryOnly ? "_Memory " : "_RamFile ");
        GeneralWorker[] WWs = new GeneralWorker[THREADS];
        int t = FILES / THREADS;
        for (int thread3 = 0; thread3 < THREADS; ++thread3) {
            WWs[thread3] = new GeneralWorker(thread3, t * thread3, t * (thread3 + 1), bufs[thread3], write, memoryOnly, msg);
        }
        long startTimeMs = System.currentTimeMillis();
        for (thread = 0; thread < THREADS; ++thread) {
            WWs[thread].start();
        }
        for (thread = 0; thread < THREADS; ++thread) {
            try {
                WWs[thread].join();
                continue;
            }
            catch (InterruptedException e) {
                CommonUtils.runtimeException(e);
            }
        }
        long takenTimeMs = System.currentTimeMillis() - startTimeMs;
        double result = 1000L * FILES_BYTES / takenTimeMs / 1024L / 1024L;
        LOG.info((Object)(result + " Mb/sec. " + RESULT_PREFIX + "Entire " + msg + " Test : " + " Took " + takenTimeMs + " ms. Current System Time: " + System.currentTimeMillis()));
    }

    private static void TachyonTest(boolean write) throws IOException {
        int thread;
        ByteBuffer[] bufs = new ByteBuffer[THREADS];
        for (int thread2 = 0; thread2 < THREADS; ++thread2) {
            ByteBuffer sRawData = ByteBuffer.allocate(BLOCK_SIZE_BYTES);
            sRawData.order(ByteOrder.nativeOrder());
            for (int k = 0; k < BLOCK_SIZE_BYTES / 4; ++k) {
                sRawData.putInt(k);
            }
            bufs[thread2] = sRawData;
        }
        Worker[] WWs = new Worker[THREADS];
        int t = FILES / THREADS;
        for (int thread3 = 0; thread3 < THREADS; ++thread3) {
            WWs[thread3] = write ? new TachyonWriterWorker(thread3, t * thread3, t * (thread3 + 1), bufs[thread3]) : new TachyonReadWorker(thread3, t * thread3, t * (thread3 + 1), bufs[thread3]);
        }
        long startTimeMs = System.currentTimeMillis();
        for (thread = 0; thread < THREADS; ++thread) {
            WWs[thread].start();
        }
        for (thread = 0; thread < THREADS; ++thread) {
            try {
                WWs[thread].join();
                continue;
            }
            catch (InterruptedException e) {
                CommonUtils.runtimeException(e);
            }
        }
        long takenTimeMs = System.currentTimeMillis() - startTimeMs;
        double result = FILES_BYTES * 1000L / takenTimeMs / 1024L / 1024L;
        LOG.info((Object)(result + " Mb/sec. " + RESULT_PREFIX + "Entire " + (write ? "Write " : "Read ") + " Took " + takenTimeMs + " ms. Current System Time: " + System.currentTimeMillis()));
    }

    private static void HdfsTest(boolean write) {
        int thread;
        ByteBuffer[] bufs = new ByteBuffer[THREADS];
        for (int thread2 = 0; thread2 < THREADS; ++thread2) {
            ByteBuffer sRawData = ByteBuffer.allocate(BLOCK_SIZE_BYTES);
            sRawData.order(ByteOrder.nativeOrder());
            for (int k = 0; k < BLOCK_SIZE_BYTES / 4; ++k) {
                sRawData.putInt(k);
            }
            bufs[thread2] = sRawData;
        }
        Worker[] WWs = new Worker[THREADS];
        int t = FILES / THREADS;
        String msg = write ? "Write " : "Read ";
        for (int thread3 = 0; thread3 < THREADS; ++thread3) {
            WWs[thread3] = new HdfsWorker(thread3, t * thread3, t * (thread3 + 1), bufs[thread3], write, msg);
        }
        long startTimeMs = System.currentTimeMillis();
        for (thread = 0; thread < THREADS; ++thread) {
            WWs[thread].start();
        }
        for (thread = 0; thread < THREADS; ++thread) {
            try {
                WWs[thread].join();
                continue;
            }
            catch (InterruptedException e) {
                CommonUtils.runtimeException(e);
            }
        }
        long takenTimeMs = System.currentTimeMillis() - startTimeMs;
        double result = FILES_BYTES * 1000L / takenTimeMs / 1024L / 1024L;
        LOG.info((Object)(result + " Mb/sec. " + RESULT_PREFIX + "Entire " + (write ? "Write " : "Read ") + " Took " + takenTimeMs + " ms. Current System Time: " + System.currentTimeMillis()));
    }

    public static void main(String[] args) throws IOException {
        int k;
        if (args.length != 9) {
            System.out.println("java -cp target/tachyon-" + Version.VERSION + "-jar-with-dependencies.jar tachyon.examples.Performance " + "<MasterIp> <FileName> <WriteBlockSizeInBytes> <BlocksPerFile> " + "<DebugMode:true/false> <Threads> <FilesPerThread> <TestCaseNumber> <BaseFileNumber>\n" + "1: Files Write Test\n" + "2: Files Read Test\n" + "3: RamFile Write Test \n" + "4: RamFile Read Test \n" + "5: ByteBuffer Write Test \n" + "6: ByteBuffer Read Test \n");
            System.exit(-1);
        }
        MASTER_ADDRESS = args[0];
        FILE_NAME = args[1];
        BLOCK_SIZE_BYTES = Integer.parseInt(args[2]);
        BLOCKS_PER_FILE = Long.parseLong(args[3]);
        DEBUG_MODE = "true".equals(args[4]);
        THREADS = Integer.parseInt(args[5]);
        FILES = Integer.parseInt(args[6]) * THREADS;
        int testCase = Integer.parseInt(args[7]);
        BASE_FILE_NUMBER = Integer.parseInt(args[8]);
        FILE_BYTES = BLOCKS_PER_FILE * (long)BLOCK_SIZE_BYTES;
        FILES_BYTES = 1L * FILE_BYTES * (long)FILES;
        RESULT_PREFIX = String.format("Threads %d FilesPerThread %d TotalFiles %d BLOCK_SIZE_KB %d BLOCKS_PER_FILE %d FILE_SIZE_MB %d Tachyon_WRITE_BUFFER_SIZE_KB %d BaseFileNumber %d : ", THREADS, FILES / THREADS, FILES, BLOCK_SIZE_BYTES / 1024, BLOCKS_PER_FILE, CommonUtils.getMB(FILE_BYTES), UserConf.get().FILE_BUFFER_BYTES / 1024, BASE_FILE_NUMBER);
        for (k = 0; k < 10000000; ++k) {
        }
        if (testCase == 1) {
            RESULT_PREFIX = "TachyonFilesWriteTest " + RESULT_PREFIX;
            LOG.info((Object)RESULT_PREFIX);
            MTC = TachyonFS.get(MASTER_ADDRESS);
            Performance.createFiles();
            Performance.TachyonTest(true);
        } else if (testCase == 2) {
            RESULT_PREFIX = "TachyonFilesReadTest " + RESULT_PREFIX;
            LOG.info((Object)RESULT_PREFIX);
            MTC = TachyonFS.get(MASTER_ADDRESS);
            Performance.TachyonTest(false);
        } else if (testCase == 3) {
            RESULT_PREFIX = "RamFile Write " + RESULT_PREFIX;
            LOG.info((Object)RESULT_PREFIX);
            Performance.memoryCopyTest(true, false);
        } else if (testCase == 4) {
            RESULT_PREFIX = "RamFile Read " + RESULT_PREFIX;
            LOG.info((Object)RESULT_PREFIX);
            Performance.memoryCopyTest(false, false);
        } else if (testCase == 5) {
            RESULT_PREFIX = "ByteBuffer Write Test " + RESULT_PREFIX;
            LOG.info((Object)RESULT_PREFIX);
            Performance.memoryCopyTest(true, true);
        } else if (testCase == 6) {
            RESULT_PREFIX = "ByteBuffer Read Test " + RESULT_PREFIX;
            LOG.info((Object)RESULT_PREFIX);
            Performance.memoryCopyTest(false, true);
        } else if (testCase == 7) {
            RESULT_PREFIX = "HdfsFilesWriteTest " + RESULT_PREFIX;
            LOG.info((Object)RESULT_PREFIX);
            Performance.HdfsTest(true);
        } else if (testCase == 8) {
            RESULT_PREFIX = "HdfsFilesReadTest " + RESULT_PREFIX;
            LOG.info((Object)RESULT_PREFIX);
            Performance.HdfsTest(false);
        } else {
            CommonUtils.runtimeException("No Test Case " + testCase);
        }
        for (k = 0; k < 64; ++k) {
            System.out.print(Results[k] + " ");
        }
        System.out.println();
        System.exit(0);
    }

    static /* synthetic */ String access$600() {
        return MASTER_ADDRESS;
    }

    public static class HdfsWorker
    extends Worker {
        private boolean mWrite;
        private String mMsg;

        public HdfsWorker(int id, int left, int right, ByteBuffer buf, boolean write, String msg) {
            super(id, left, right, buf);
            this.mWrite = write;
            this.mMsg = msg;
        }

        public void io() throws IOException {
            if (DEBUG_MODE) {
                this.mBuf.flip();
                CommonUtils.printByteBuffer(LOG, this.mBuf);
            }
            this.mBuf.flip();
            long sum = 0L;
            String str = "th " + this.mMsg + " @ Worker ";
            Configuration tConf = new Configuration();
            tConf.set("fs.default.name", FILE_NAME);
            tConf.set("fs.defaultFS", FILE_NAME);
            tConf.set("fs.hdfs.impl", "org.apache.hadoop.hdfs.DistributedFileSystem");
            FileSystem fs = FileSystem.get((Configuration)tConf);
            if (this.mWrite) {
                for (int times = this.mLeft; times < this.mRight; ++times) {
                    long startTimeMs = System.currentTimeMillis();
                    String filePath = FILE_NAME + (this.mWorkerId + BASE_FILE_NUMBER);
                    FSDataOutputStream os = fs.create(new Path(filePath));
                    int k = 0;
                    while ((long)k < BLOCKS_PER_FILE) {
                        this.mBuf.array()[0] = (byte)(k + this.mWorkerId);
                        os.write(this.mBuf.array());
                        ++k;
                    }
                    os.close();
                    Performance.logPerIteration(startTimeMs, times, str, this.mWorkerId);
                }
            } else {
                for (int times = this.mLeft; times < this.mRight; ++times) {
                    int r;
                    long startTimeMs = System.currentTimeMillis();
                    String filePath = FILE_NAME + (this.mWorkerId + BASE_FILE_NUMBER);
                    FSDataInputStream is = fs.open(new Path(filePath));
                    for (long len = BLOCKS_PER_FILE * (long)BLOCK_SIZE_BYTES; len > 0L; len -= (long)r) {
                        r = is.read(this.mBuf.array());
                        if (r != -1) continue;
                        CommonUtils.runtimeException("R == -1");
                    }
                    is.close();
                    Performance.logPerIteration(startTimeMs, times, str, this.mWorkerId);
                }
            }
            Results[this.mWorkerId] = sum;
        }

        @Override
        public void run() {
            try {
                this.io();
            }
            catch (IOException e) {
                CommonUtils.runtimeException(e);
            }
            LOG.info((Object)(this.mMsg + this.mWorkerId + " just finished."));
        }
    }

    public static class TachyonReadWorker
    extends Worker {
        private TachyonFS mTC = TachyonFS.get(Performance.access$600());

        public TachyonReadWorker(int id, int left, int right, ByteBuffer buf) throws IOException {
            super(id, left, right, buf);
        }

        public void readPartition() throws IOException {
            TachyonByteBuffer buf;
            if (DEBUG_MODE) {
                LOG.info((Object)"Verifying the reading data...");
                for (int pId = this.mLeft; pId < this.mRight; ++pId) {
                    TachyonFile file = this.mTC.getFile(FILE_NAME + this.mWorkerId);
                    buf = file.readByteBuffer();
                    IntBuffer intBuf = buf.DATA.asIntBuffer();
                    int i = 0;
                    while ((long)i < BLOCKS_PER_FILE) {
                        for (int k = 0; k < BLOCK_SIZE_BYTES / 4; ++k) {
                            int tmp = intBuf.get();
                            if (k == 0 && tmp == i + this.mWorkerId || k != 0 && tmp == k) continue;
                            CommonUtils.runtimeException("WHAT? " + tmp + " " + k);
                        }
                        ++i;
                    }
                    buf.close();
                }
            }
            long sum = 0L;
            for (int pId = this.mLeft; pId < this.mRight; ++pId) {
                long startTimeMs = System.currentTimeMillis();
                TachyonFile file = this.mTC.getFile(FILE_NAME + (this.mWorkerId + BASE_FILE_NUMBER));
                buf = file.readByteBuffer();
                int i = 0;
                while ((long)i < BLOCKS_PER_FILE) {
                    buf.DATA.get(this.mBuf.array());
                    ++i;
                }
                sum += (long)this.mBuf.get(pId % 16);
                if (DEBUG_MODE) {
                    buf.DATA.flip();
                    CommonUtils.printByteBuffer(LOG, buf.DATA);
                }
                buf.DATA.clear();
                Performance.logPerIteration(startTimeMs, pId, "th ReadTachyonFile @ Worker ", pId);
                buf.close();
            }
            Results[this.mWorkerId] = sum;
        }

        @Override
        public void run() {
            try {
                this.readPartition();
            }
            catch (Exception e) {
                CommonUtils.runtimeException(e);
            }
            LOG.info((Object)("ReadWorker " + this.mWorkerId + " just finished."));
        }
    }

    public static class TachyonWriterWorker
    extends Worker {
        private TachyonFS mTC = TachyonFS.get(Performance.access$600());

        public TachyonWriterWorker(int id, int left, int right, ByteBuffer buf) throws IOException {
            super(id, left, right, buf);
        }

        public void writeParition() throws IOException {
            if (DEBUG_MODE) {
                this.mBuf.flip();
                CommonUtils.printByteBuffer(LOG, this.mBuf);
            }
            this.mBuf.flip();
            for (int pId = this.mLeft; pId < this.mRight; ++pId) {
                long startTimeMs = System.currentTimeMillis();
                TachyonFile file = this.mTC.getFile(FILE_NAME + (this.mWorkerId + BASE_FILE_NUMBER));
                OutStream os = file.getOutStream(WriteType.MUST_CACHE);
                int k = 0;
                while ((long)k < BLOCKS_PER_FILE) {
                    this.mBuf.array()[0] = (byte)(k + this.mWorkerId);
                    os.write(this.mBuf.array());
                    ++k;
                }
                os.close();
                Performance.logPerIteration(startTimeMs, pId, "th WriteTachyonFile @ Worker ", pId);
            }
        }

        @Override
        public void run() {
            try {
                this.writeParition();
            }
            catch (Exception e) {
                CommonUtils.runtimeException(e);
            }
            LOG.info((Object)("WriteWorker " + this.mWorkerId + " just finished."));
        }
    }

    public static class GeneralWorker
    extends Worker {
        private boolean mOneToMany;
        private boolean mMemoryOnly;
        private String mMsg;

        public GeneralWorker(int id, int left, int right, ByteBuffer buf, boolean oneToMany, boolean memoryOnly, String msg) {
            super(id, left, right, buf);
            this.mOneToMany = oneToMany;
            this.mMemoryOnly = memoryOnly;
            this.mMsg = msg;
        }

        public void memoryCopyParition() throws IOException {
            if (DEBUG_MODE) {
                this.mBuf.flip();
                CommonUtils.printByteBuffer(LOG, this.mBuf);
            }
            this.mBuf.flip();
            long sum = 0L;
            String str = "th " + this.mMsg + " @ Worker ";
            if (this.mOneToMany) {
                ByteBuffer dst = null;
                RandomAccessFile file = null;
                if (this.mMemoryOnly) {
                    dst = ByteBuffer.allocateDirect((int)FILE_BYTES);
                }
                for (int times = this.mLeft; times < this.mRight; ++times) {
                    long startTimeMs = System.currentTimeMillis();
                    if (!this.mMemoryOnly) {
                        file = new RandomAccessFile(Performance.FOLDER + (this.mWorkerId + BASE_FILE_NUMBER), "rw");
                        dst = file.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, FILE_BYTES);
                    }
                    dst.order(ByteOrder.nativeOrder());
                    int k = 0;
                    while ((long)k < BLOCKS_PER_FILE) {
                        this.mBuf.array()[0] = (byte)(k + this.mWorkerId);
                        dst.put(this.mBuf.array());
                        ++k;
                    }
                    dst.clear();
                    sum += (long)dst.get(times);
                    dst.clear();
                    if (!this.mMemoryOnly) {
                        file.close();
                    }
                    Performance.logPerIteration(startTimeMs, times, str, this.mWorkerId);
                }
            } else {
                ByteBuffer dst = null;
                RandomAccessFile file = null;
                if (this.mMemoryOnly) {
                    dst = ByteBuffer.allocateDirect((int)FILE_BYTES);
                }
                for (int times = this.mLeft; times < this.mRight; ++times) {
                    long startTimeMs = System.currentTimeMillis();
                    if (!this.mMemoryOnly) {
                        file = new RandomAccessFile(Performance.FOLDER + (this.mWorkerId + BASE_FILE_NUMBER), "rw");
                        dst = file.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, FILE_BYTES);
                    }
                    dst.order(ByteOrder.nativeOrder());
                    int k = 0;
                    while ((long)k < BLOCKS_PER_FILE) {
                        dst.get(this.mBuf.array());
                        ++k;
                    }
                    sum += (long)this.mBuf.get(times % 16);
                    dst.clear();
                    if (!this.mMemoryOnly) {
                        file.close();
                    }
                    Performance.logPerIteration(startTimeMs, times, str, this.mWorkerId);
                }
            }
            Results[this.mWorkerId] = sum;
        }

        @Override
        public void run() {
            try {
                this.memoryCopyParition();
            }
            catch (IOException e) {
                CommonUtils.runtimeException(e);
            }
            LOG.info((Object)(this.mMsg + this.mWorkerId + " just finished."));
        }
    }

    public static abstract class Worker
    extends Thread {
        protected int mWorkerId;
        protected int mLeft;
        protected int mRight;
        protected ByteBuffer mBuf;

        public Worker(int id, int left, int right, ByteBuffer buf) {
            this.mWorkerId = id;
            this.mLeft = left;
            this.mRight = right;
            this.mBuf = buf;
        }
    }
}

