/*
 * Decompiled with CFR 0.152.
 */
package tachyon.conf;

import java.util.ArrayList;
import java.util.Arrays;
import tachyon.conf.CommonConf;
import tachyon.conf.Utils;

public class MasterConf
extends Utils {
    private static MasterConf MASTER_CONF = null;
    public final String JOURNAL_FOLDER;
    public final String FORMAT_FILE_PREFIX;
    public final String HOSTNAME;
    public final int PORT;
    public final int WEB_PORT;
    public final String TEMPORARY_FOLDER;
    public final int HEARTBEAT_INTERVAL_MS;
    public final int SELECTOR_THREADS;
    public final int QUEUE_SIZE_PER_SELECTOR;
    public final int SERVER_THREADS;
    public final int WORKER_TIMEOUT_MS;
    public final ArrayList<String> WHITELIST = new ArrayList();
    public final ArrayList<String> PINLIST = new ArrayList();

    private MasterConf() {
        this.JOURNAL_FOLDER = MasterConf.getProperty("tachyon.master.journal.folder", CommonConf.get().TACHYON_HOME + "/journal/");
        this.FORMAT_FILE_PREFIX = "_format_";
        this.HOSTNAME = MasterConf.getProperty("tachyon.master.hostname", "localhost");
        this.PORT = MasterConf.getIntProperty("tachyon.master.port", 19998);
        this.WEB_PORT = MasterConf.getIntProperty("tachyon.master.web.port", 19999);
        this.TEMPORARY_FOLDER = MasterConf.getProperty("tachyon.master.temporary.folder", "/tmp");
        this.HEARTBEAT_INTERVAL_MS = MasterConf.getIntProperty("tachyon.master.heartbeat.interval.ms", 1000);
        this.SELECTOR_THREADS = MasterConf.getIntProperty("tachyon.master.selector.threads", 3);
        this.QUEUE_SIZE_PER_SELECTOR = MasterConf.getIntProperty("tachyon.master.queue.size.per.selector", 3000);
        this.SERVER_THREADS = MasterConf.getIntProperty("tachyon.master.server.threads", 128);
        this.WORKER_TIMEOUT_MS = MasterConf.getIntProperty("tachyon.master.worker.timeout.ms", 10000);
        this.WHITELIST.addAll(Arrays.asList(MasterConf.getProperty("tachyon.master.whitelist", "/").split(";")));
        String tPinList = MasterConf.getProperty("tachyon.master.pinlist", null);
        if (tPinList != null && !tPinList.isEmpty()) {
            this.PINLIST.addAll(Arrays.asList(tPinList.split(";")));
        }
    }

    public static synchronized MasterConf get() {
        if (MASTER_CONF == null) {
            MASTER_CONF = new MasterConf();
        }
        return MASTER_CONF;
    }

    public static synchronized void clear() {
        MASTER_CONF = null;
    }
}

