/*
 * Decompiled with CFR 0.152.
 */
package tachyon.org.jets3t.service.multithread;

import tachyon.org.jets3t.service.model.S3Object;
import tachyon.org.jets3t.service.multithread.ServiceEvent;
import tachyon.org.jets3t.service.multithread.ThreadWatcher;

public class DeleteObjectsEvent
extends ServiceEvent {
    private S3Object[] objects = null;

    private DeleteObjectsEvent(int eventCode, Object uniqueOperationId) {
        super(eventCode, uniqueOperationId);
    }

    public static DeleteObjectsEvent newErrorEvent(Throwable t, Object uniqueOperationId) {
        DeleteObjectsEvent event = new DeleteObjectsEvent(0, uniqueOperationId);
        event.setErrorCause(t);
        return event;
    }

    public static DeleteObjectsEvent newStartedEvent(ThreadWatcher threadWatcher, Object uniqueOperationId) {
        DeleteObjectsEvent event = new DeleteObjectsEvent(1, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static DeleteObjectsEvent newInProgressEvent(ThreadWatcher threadWatcher, S3Object[] deletedObjects, Object uniqueOperationId) {
        DeleteObjectsEvent event = new DeleteObjectsEvent(3, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        event.setObjects(deletedObjects);
        return event;
    }

    public static DeleteObjectsEvent newCompletedEvent(Object uniqueOperationId) {
        DeleteObjectsEvent event = new DeleteObjectsEvent(2, uniqueOperationId);
        return event;
    }

    public static DeleteObjectsEvent newCancelledEvent(S3Object[] remainingObjects, Object uniqueOperationId) {
        DeleteObjectsEvent event = new DeleteObjectsEvent(4, uniqueOperationId);
        event.setObjects(remainingObjects);
        return event;
    }

    public static DeleteObjectsEvent newIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors, Object uniqueOperationId) {
        DeleteObjectsEvent event = new DeleteObjectsEvent(5, uniqueOperationId);
        event.setIgnoredErrors(ignoredErrors);
        return event;
    }

    private void setObjects(S3Object[] objects) {
        this.objects = objects;
    }

    public S3Object[] getDeletedObjects() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Deleted Objects are only available from EVENT_IN_PROGRESS events");
        }
        return this.objects;
    }

    public S3Object[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are  only available from EVENT_CANCELLED events");
        }
        return this.objects;
    }
}

