/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.lineage;

import java.io.IOException;
import java.util.List;
import tachyon.TachyonURI;
import tachyon.client.ClientContext;
import tachyon.client.lineage.AbstractLineageClient;
import tachyon.client.lineage.options.CreateLineageOptions;
import tachyon.client.lineage.options.DeleteLineageOptions;
import tachyon.client.lineage.options.GetLineageInfoListOptions;
import tachyon.exception.FileDoesNotExistException;
import tachyon.exception.LineageDeletionException;
import tachyon.exception.LineageDoesNotExistException;
import tachyon.exception.TachyonException;
import tachyon.job.Job;
import tachyon.thrift.LineageInfo;

public final class TachyonLineage
extends AbstractLineageClient {
    private static TachyonLineage sTachyonLineage;

    public static synchronized TachyonLineage get() {
        if (sTachyonLineage == null) {
            if (!ClientContext.getConf().getBoolean("tachyon.user.lineage.enabled")) {
                throw new IllegalStateException("Lineage is not enabled in the configuration.");
            }
            sTachyonLineage = new TachyonLineage();
        }
        return sTachyonLineage;
    }

    private TachyonLineage() {
    }

    public long createLineage(List<TachyonURI> inputFiles, List<TachyonURI> outputFiles, Job job) throws FileDoesNotExistException, TachyonException, IOException {
        return this.createLineage(inputFiles, outputFiles, job, CreateLineageOptions.defaults());
    }

    public boolean deleteLineage(long lineageId) throws IOException, LineageDoesNotExistException, LineageDeletionException, TachyonException {
        return this.deleteLineage(lineageId, DeleteLineageOptions.defaults());
    }

    public List<LineageInfo> getLineageInfoList() throws IOException {
        return this.getLineageInfoList(GetLineageInfoListOptions.defaults());
    }
}

