/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.wiser;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.wiser.Wiser;

public class WiserMessage {
    private static final Logger log = LoggerFactory.getLogger(WiserMessage.class);
    Wiser wiser;
    String envelopeSender;
    String envelopeReceiver;
    InputStream stream;
    byte[] array;
    MimeMessage message = null;

    WiserMessage(Wiser wiser, String envelopeSender, String envelopeReceiver, InputStream stream) {
        this.wiser = wiser;
        this.envelopeSender = envelopeSender;
        this.envelopeReceiver = envelopeReceiver;
        this.stream = stream;
    }

    public MimeMessage getMimeMessage() throws MessagingException {
        if (this.message == null) {
            this.message = new MimeMessage(this.wiser.getSession(), this.stream);
        }
        return this.message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData() {
        if (this.array == null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedInputStream in = this.stream instanceof BufferedInputStream ? (BufferedInputStream)this.stream : new BufferedInputStream(this.stream);
            try {
                int b;
                byte[] buf = new byte[8192];
                while ((b = in.read(buf)) >= 0) {
                    out.write(buf, 0, b);
                }
                this.array = out.toByteArray();
            }
            catch (IOException ioex) {
                this.array = new byte[0];
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.array;
    }

    public String getEnvelopeReceiver() {
        return this.envelopeReceiver;
    }

    public String getEnvelopeSender() {
        return this.envelopeSender;
    }

    public void dispose() {
        try {
            this.finalize();
        }
        catch (Throwable t) {
            log.error("On WiserMessage dispose", t);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.stream != null) {
            this.stream.close();
        }
    }
}

