/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.mina.common.BufferDataException;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.server.ConnectionHandler;
import org.subethamail.smtp.server.io.SharedTmpFileInputStream;

public class SMTPCodecDecoder
implements ProtocolDecoder {
    private static final Logger log = LoggerFactory.getLogger(SMTPCodecDecoder.class);
    private static final String CONTEXT = SMTPCodecDecoder.class.getName() + ".context";
    private static final String TMPFILE_PREFIX = "subetha";
    private static final String TMPFILE_SUFFIX = ".eml";
    private static final byte[] SMTP_CMD_DELIMITER = new byte[]{13, 10};
    private static final byte[] SMTP_DATA_DELIMITER = new byte[]{13, 10, 46, 13, 10};
    private final Charset charset;
    private int maxLineLength = 998;
    private int threshold;

    public SMTPCodecDecoder(Charset charset, int thresholdBytes) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.charset = charset;
        this.threshold = thresholdBytes;
    }

    public void setDataDeferredSize(int dataDeferredSize) {
        this.threshold = dataDeferredSize;
    }

    public static byte[] asArray(ByteBuffer b) {
        int l = b.remaining();
        byte[] array = new byte[l];
        b.get(array, 0, l);
        return array;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setMaxLineLength(int maxLineLength) {
        if (maxLineLength <= 0) {
            throw new IllegalArgumentException("maxLineLength: " + maxLineLength);
        }
        this.maxLineLength = maxLineLength;
    }

    private Context getContext(IoSession session) {
        Context ctx = (Context)session.getAttribute(CONTEXT);
        if (ctx == null) {
            ctx = new Context();
            session.setAttribute(CONTEXT, (Object)ctx);
        }
        return ctx;
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
    }

    public void dispose(IoSession session) throws Exception {
        Context ctx = (Context)session.getAttribute(CONTEXT);
        if (ctx != null) {
            ctx.getBuffer().release();
            ctx.closeOutputStream();
            session.removeAttribute(CONTEXT);
        }
    }

    public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        Context ctx = this.getContext(session);
        int matchCount = ctx.getMatchCount();
        ConnectionHandler.Context minaCtx = (ConnectionHandler.Context)session.getAttribute(ConnectionHandler.CONTEXT_ATTRIBUTE);
        boolean dataMode = minaCtx.getSession().isDataMode();
        byte[] delimBuf = dataMode ? SMTP_DATA_DELIMITER : SMTP_CMD_DELIMITER;
        int oldPos = in.position();
        int oldLimit = in.limit();
        if (matchCount == delimBuf.length) {
            matchCount = 0;
        }
        while (in.remaining() > 0) {
            byte b = in.get();
            if (delimBuf[matchCount] == b) {
                if (++matchCount != delimBuf.length) continue;
                int pos = in.position();
                in.limit(pos);
                in.position(oldPos);
                ctx.write(dataMode, in);
                in.limit(oldLimit);
                in.position(pos);
                if (ctx.getOverflowPosition() == 0) {
                    ByteBuffer buf = ctx.getBuffer();
                    buf.flip();
                    if (!dataMode) {
                        buf.limit(buf.limit() - matchCount);
                    }
                    try {
                        if (dataMode) {
                            delimBuf = SMTP_CMD_DELIMITER;
                            out.write((Object)ctx.getInputStream());
                            ctx.compactBuffer();
                        }
                        out.write((Object)buf.getString(ctx.getDecoder()));
                    }
                    catch (IOException ioex) {
                        throw new CharacterCodingException();
                    }
                    finally {
                        buf.clear();
                    }
                } else {
                    int overflowPosition = ctx.getOverflowPosition();
                    ctx.reset();
                    throw new BufferDataException("Line is too long: " + overflowPosition);
                }
                oldPos = pos;
                matchCount = 0;
                continue;
            }
            in.position(Math.max(0, in.position() - matchCount));
            matchCount = 0;
        }
        in.position(oldPos);
        ctx.write(dataMode, in);
        ctx.setMatchCount(matchCount);
    }

    private class Context {
        private final CharsetDecoder decoder;
        private ByteBuffer buf;
        private int matchCount = 0;
        private int overflowPosition = 0;
        private boolean thresholdReached = false;
        File outFile;
        FileOutputStream stream;

        private Context() {
            this.decoder = SMTPCodecDecoder.this.charset.newDecoder();
            this.buf = ByteBuffer.allocate((int)80).setAutoExpand(true);
        }

        public CharsetDecoder getDecoder() {
            return this.decoder;
        }

        public ByteBuffer getBuffer() {
            return this.buf;
        }

        public void compactBuffer() {
            this.buf.clear();
            if (this.buf.capacity() > SMTPCodecDecoder.this.getMaxLineLength()) {
                this.buf.release();
                this.buf = ByteBuffer.allocate((int)80).setAutoExpand(true);
            }
        }

        public int getOverflowPosition() {
            return this.overflowPosition;
        }

        public int getMatchCount() {
            return this.matchCount;
        }

        public void setMatchCount(int matchCount) {
            this.matchCount = matchCount;
        }

        public void reset() {
            this.overflowPosition = 0;
            this.matchCount = 0;
            this.decoder.reset();
        }

        public void write(boolean dataMode, ByteBuffer b) throws IOException {
            if (dataMode) {
                this.write(SMTPCodecDecoder.asArray(b));
            } else {
                this.append(b);
            }
        }

        public void write(byte[] src) throws IOException {
            int predicted;
            int n = predicted = this.thresholdReached ? 0 : this.buf.position() + src.length;
            if (this.thresholdReached || predicted > SMTPCodecDecoder.this.threshold) {
                if (!this.thresholdReached) {
                    this.thresholdReached(this.buf.position(), predicted);
                    this.thresholdReached = true;
                    this.compactBuffer();
                }
                this.stream.write(src);
            } else {
                this.buf.put(src);
            }
        }

        private void thresholdReached(int current, int predicted) throws IOException {
            this.outFile = File.createTempFile(SMTPCodecDecoder.TMPFILE_PREFIX, SMTPCodecDecoder.TMPFILE_SUFFIX);
            if (log.isDebugEnabled()) {
                log.debug("Writing message to file : " + this.outFile.getAbsolutePath());
            }
            this.stream = new FileOutputStream(this.outFile);
            this.buf.flip();
            this.stream.write(SMTPCodecDecoder.asArray(this.buf));
            log.debug("ByteBuffer written to stream");
        }

        public void closeOutputStream() throws IOException {
            if (this.stream != null) {
                this.stream.flush();
                this.stream.close();
                log.debug("Temp file writing achieved");
            }
        }

        public InputStream getInputStream() throws IOException {
            if (this.thresholdReached) {
                return new SharedTmpFileInputStream(this.outFile);
            }
            return new SharedByteArrayInputStream(SMTPCodecDecoder.asArray(this.buf));
        }

        public void append(ByteBuffer in) throws CharacterCodingException {
            if (this.overflowPosition != 0) {
                this.discard(in);
            } else {
                int pos = this.buf.position();
                if (pos > SMTPCodecDecoder.this.maxLineLength - in.remaining()) {
                    this.overflowPosition = pos;
                    this.buf.clear();
                    this.discard(in);
                } else {
                    this.buf.put(in);
                }
            }
        }

        private void discard(ByteBuffer in) {
            this.overflowPosition = Integer.MAX_VALUE - in.remaining() < this.overflowPosition ? Integer.MAX_VALUE : (this.overflowPosition += in.remaining());
            in.position(in.limit());
        }
    }
}

