/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.command;

import java.io.IOException;
import org.apache.mina.common.IoFilter;
import org.apache.mina.filter.SSLFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.server.BaseCommand;
import org.subethamail.smtp.server.ConnectionContext;
import org.subethamail.smtp.server.io.DummySSLSocketFactory;

public class StartTLSCommand
extends BaseCommand {
    private static Logger log = LoggerFactory.getLogger(StartTLSCommand.class);
    private static SSLFilter sslFilter;

    public StartTLSCommand() {
        super("STARTTLS", "The starttls command");
    }

    public static void setSSLFilter(SSLFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter argument can't be null");
        }
        sslFilter = filter;
    }

    public void execute(String commandString, ConnectionContext context) throws IOException {
        if (!commandString.trim().toUpperCase().equals(this.getName())) {
            context.sendResponse("501 Syntax error (no parameters allowed)");
            return;
        }
        try {
            if (sslFilter.isSSLStarted(context.getIOSession())) {
                context.sendResponse("454 TLS not available due to temporary reason: TLS already active");
                return;
            }
            context.getIOSession().getFilterChain().addFirst("SSLfilter", (IoFilter)sslFilter);
            context.getIOSession().setAttribute(SSLFilter.DISABLE_ENCRYPTION_ONCE, (Object)Boolean.TRUE);
            context.sendResponse("220 Ready to start TLS");
            assert (context.getIOSession().getAttribute(SSLFilter.DISABLE_ENCRYPTION_ONCE) == null);
            context.getSession().reset();
        }
        catch (Exception e) {
            log.warn("startTLS() failed: " + e.getMessage(), (Throwable)e);
        }
    }

    static {
        try {
            DummySSLSocketFactory socketFactory = new DummySSLSocketFactory();
            sslFilter = new SSLFilter(socketFactory.getSSLContext());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

