/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.test.server;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.context.DefaultMessageContext;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.soap.saaj.SaajSoapMessageFactory;
import org.springframework.ws.soap.server.SoapMessageDispatcher;
import org.springframework.ws.test.server.RequestCreator;
import org.springframework.ws.test.server.ResponseActions;
import org.springframework.ws.test.server.ResponseMatcher;
import org.springframework.ws.test.support.AssertionErrors;
import org.springframework.ws.test.support.MockStrategiesHelper;
import org.springframework.ws.transport.WebServiceMessageReceiver;

public final class MockWebServiceClient {
    private static final Log logger = LogFactory.getLog(MockWebServiceClient.class);
    private final WebServiceMessageReceiver messageReceiver;
    private final WebServiceMessageFactory messageFactory;

    private MockWebServiceClient(WebServiceMessageReceiver messageReceiver, WebServiceMessageFactory messageFactory) {
        Assert.notNull((Object)messageReceiver, (String)"'messageReceiver' must not be null");
        Assert.notNull((Object)messageFactory, (String)"'messageFactory' must not be null");
        this.messageReceiver = messageReceiver;
        this.messageFactory = messageFactory;
    }

    public static MockWebServiceClient createClient(WebServiceMessageReceiver messageReceiver, WebServiceMessageFactory messageFactory) {
        return new MockWebServiceClient(messageReceiver, messageFactory);
    }

    public static MockWebServiceClient createClient(ApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"'applicationContext' must not be null");
        MockStrategiesHelper strategiesHelper = new MockStrategiesHelper(applicationContext);
        WebServiceMessageReceiver messageReceiver = strategiesHelper.getStrategy(WebServiceMessageReceiver.class, SoapMessageDispatcher.class);
        WebServiceMessageFactory messageFactory = strategiesHelper.getStrategy(WebServiceMessageFactory.class, SaajSoapMessageFactory.class);
        return new MockWebServiceClient(messageReceiver, messageFactory);
    }

    public ResponseActions sendRequest(RequestCreator requestCreator) {
        Assert.notNull((Object)requestCreator, (String)"'requestCreator' must not be null");
        try {
            WebServiceMessage request = requestCreator.createRequest(this.messageFactory);
            DefaultMessageContext messageContext = new DefaultMessageContext(request, this.messageFactory);
            this.messageReceiver.receive((MessageContext)messageContext);
            return new MockWebServiceClientResponseActions((MessageContext)messageContext);
        }
        catch (Exception ex) {
            logger.error((Object)"Could not send request", (Throwable)ex);
            AssertionErrors.fail(ex.getMessage());
            return null;
        }
    }

    private static final class MockWebServiceClientResponseActions
    implements ResponseActions {
        private final MessageContext messageContext;

        private MockWebServiceClientResponseActions(MessageContext messageContext) {
            Assert.notNull((Object)messageContext, (String)"'messageContext' must not be null");
            this.messageContext = messageContext;
        }

        @Override
        public ResponseActions andExpect(ResponseMatcher responseMatcher) {
            WebServiceMessage request = this.messageContext.getRequest();
            WebServiceMessage response = this.messageContext.getResponse();
            if (response == null) {
                AssertionErrors.fail("No response received");
                return null;
            }
            try {
                responseMatcher.match(request, response);
                return this;
            }
            catch (IOException ex) {
                logger.error((Object)"Could not match request", (Throwable)ex);
                AssertionErrors.fail(ex.getMessage());
                return null;
            }
        }
    }
}

