/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.test.client;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.ws.test.client.RequestMatcher;
import org.springframework.ws.test.client.RequestXPathExpectations;
import org.springframework.ws.test.client.UriMatcher;
import org.springframework.ws.test.client.WebServiceMessageMatcherAdapter;
import org.springframework.ws.test.client.XPathExpectationsHelperAdapter;
import org.springframework.ws.test.support.matcher.SchemaValidatingMatcher;
import org.springframework.ws.test.support.matcher.SoapHeaderMatcher;
import org.springframework.ws.test.support.matcher.xmlunit2.PayloadDiffMatcher;
import org.springframework.ws.test.support.matcher.xmlunit2.SoapEnvelopeDiffMatcher;
import org.springframework.xml.transform.ResourceSource;

public abstract class RequestMatchers {
    private RequestMatchers() {
    }

    public static RequestMatcher anything() {
        return (uri, request) -> {};
    }

    public static RequestMatcher payload(Source payload) {
        Assert.notNull((Object)payload, (String)"'payload' must not be null");
        return new WebServiceMessageMatcherAdapter(new PayloadDiffMatcher(payload));
    }

    public static RequestMatcher payload(Resource payload) throws IOException {
        Assert.notNull((Object)payload, (String)"'payload' must not be null");
        return RequestMatchers.payload((Source)new ResourceSource(payload));
    }

    public static RequestMatcher validPayload(Resource schema, Resource ... furtherSchemas) throws IOException {
        return new WebServiceMessageMatcherAdapter(new SchemaValidatingMatcher(schema, furtherSchemas));
    }

    public static RequestXPathExpectations xpath(String xpathExpression) {
        return new XPathExpectationsHelperAdapter(xpathExpression, null);
    }

    public static RequestXPathExpectations xpath(String xpathExpression, Map<String, String> namespaceMapping) {
        return new XPathExpectationsHelperAdapter(xpathExpression, namespaceMapping);
    }

    public static RequestMatcher soapEnvelope(Source soapEnvelope) {
        Assert.notNull((Object)soapEnvelope, (String)"'soapEnvelope' must not be null");
        return new WebServiceMessageMatcherAdapter(new SoapEnvelopeDiffMatcher(soapEnvelope));
    }

    public static RequestMatcher soapEnvelope(Resource soapEnvelope) throws IOException {
        Assert.notNull((Object)soapEnvelope, (String)"'soapEnvelope' must not be null");
        return RequestMatchers.soapEnvelope((Source)new ResourceSource(soapEnvelope));
    }

    public static RequestMatcher soapHeader(QName soapHeaderName) {
        Assert.notNull((Object)soapHeaderName, (String)"'soapHeaderName' must not be null");
        return new WebServiceMessageMatcherAdapter(new SoapHeaderMatcher(soapHeaderName));
    }

    public static RequestMatcher connectionTo(String uri) {
        Assert.notNull((Object)uri, (String)"'uri' must not be null");
        return RequestMatchers.connectionTo(URI.create(uri));
    }

    public static RequestMatcher connectionTo(URI uri) {
        Assert.notNull((Object)uri, (String)"'uri' must not be null");
        return new UriMatcher(uri);
    }
}

