/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.jetty;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.jetty.ee11.websocket.server.JettyWebSocketCreator;
import org.eclipse.jetty.ee11.websocket.server.JettyWebSocketServerContainer;
import org.eclipse.jetty.websocket.api.Configurable;
import org.jspecify.annotations.Nullable;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.adapter.jetty.JettyWebSocketHandlerAdapter;
import org.springframework.web.socket.adapter.jetty.JettyWebSocketSession;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.RequestUpgradeStrategy;

public class JettyRequestUpgradeStrategy
implements RequestUpgradeStrategy,
ServletContextAware {
    private static final String[] SUPPORTED_VERSIONS = new String[]{"13"};
    private @Nullable Consumer<Configurable> webSocketConfigurer;

    @Override
    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    @Override
    public List<WebSocketExtension> getSupportedExtensions(ServerHttpRequest request) {
        return Collections.emptyList();
    }

    public void addWebSocketConfigurer(Consumer<Configurable> webSocketConfigurer) {
        this.webSocketConfigurer = this.webSocketConfigurer != null ? this.webSocketConfigurer.andThen(webSocketConfigurer) : webSocketConfigurer;
    }

    public void setServletContext(ServletContext servletContext) {
        JettyWebSocketServerContainer container = JettyWebSocketServerContainer.getContainer((ServletContext)servletContext);
        if (container != null && this.webSocketConfigurer != null) {
            this.webSocketConfigurer.accept((Configurable)container);
        }
    }

    @Override
    public void upgrade(ServerHttpRequest request, ServerHttpResponse response, @Nullable String selectedProtocol, List<WebSocketExtension> selectedExtensions, @Nullable Principal user, WebSocketHandler handler, Map<String, Object> attributes) throws HandshakeFailureException {
        Assert.isInstanceOf(ServletServerHttpRequest.class, (Object)request, (String)"ServletServerHttpRequest required");
        HttpServletRequest servletRequest = ((ServletServerHttpRequest)request).getServletRequest();
        ServletContext servletContext = servletRequest.getServletContext();
        Assert.isInstanceOf(ServletServerHttpResponse.class, (Object)response, (String)"ServletServerHttpResponse required");
        HttpServletResponse servletResponse = ((ServletServerHttpResponse)response).getServletResponse();
        JettyWebSocketSession session = new JettyWebSocketSession(attributes, user);
        JettyWebSocketHandlerAdapter handlerAdapter = new JettyWebSocketHandlerAdapter(handler, session);
        JettyWebSocketCreator webSocketCreator = (upgradeRequest, upgradeResponse) -> {
            if (selectedProtocol != null) {
                upgradeResponse.setAcceptedSubProtocol(selectedProtocol);
            }
            return handlerAdapter;
        };
        JettyWebSocketServerContainer container = JettyWebSocketServerContainer.getContainer((ServletContext)servletContext);
        try {
            container.upgrade(webSocketCreator, servletRequest, servletResponse);
        }
        catch (UndeclaredThrowableException ex) {
            throw new HandshakeFailureException("Failed to upgrade", ex.getUndeclaredThrowable());
        }
        catch (Exception ex) {
            throw new HandshakeFailureException("Failed to upgrade", ex);
        }
    }
}

