/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import jakarta.servlet.jsp.JspException;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.web.servlet.tags.form.AbstractHtmlInputElementTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public class InputTag
extends AbstractHtmlInputElementTag {
    public static final String SIZE_ATTRIBUTE = "size";
    public static final String MAXLENGTH_ATTRIBUTE = "maxlength";
    public static final String ALT_ATTRIBUTE = "alt";
    public static final String ONSELECT_ATTRIBUTE = "onselect";
    public static final String AUTOCOMPLETE_ATTRIBUTE = "autocomplete";
    private @Nullable String size;
    private @Nullable String maxlength;
    private @Nullable String alt;
    private @Nullable String onselect;
    private @Nullable String autocomplete;

    public void setSize(String size) {
        this.size = size;
    }

    protected @Nullable String getSize() {
        return this.size;
    }

    public void setMaxlength(String maxlength) {
        this.maxlength = maxlength;
    }

    protected @Nullable String getMaxlength() {
        return this.maxlength;
    }

    public void setAlt(String alt) {
        this.alt = alt;
    }

    protected @Nullable String getAlt() {
        return this.alt;
    }

    public void setOnselect(String onselect) {
        this.onselect = onselect;
    }

    protected @Nullable String getOnselect() {
        return this.onselect;
    }

    public void setAutocomplete(String autocomplete) {
        this.autocomplete = autocomplete;
    }

    protected @Nullable String getAutocomplete() {
        return this.autocomplete;
    }

    @Override
    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        tagWriter.startTag("input");
        this.writeDefaultAttributes(tagWriter);
        Map<String, Object> attributes = this.getDynamicAttributes();
        if (attributes == null || !attributes.containsKey("type")) {
            tagWriter.writeAttribute("type", this.getType());
        }
        this.writeValue(tagWriter);
        this.writeOptionalAttribute(tagWriter, SIZE_ATTRIBUTE, this.getSize());
        this.writeOptionalAttribute(tagWriter, MAXLENGTH_ATTRIBUTE, this.getMaxlength());
        this.writeOptionalAttribute(tagWriter, ALT_ATTRIBUTE, this.getAlt());
        this.writeOptionalAttribute(tagWriter, ONSELECT_ATTRIBUTE, this.getOnselect());
        this.writeOptionalAttribute(tagWriter, AUTOCOMPLETE_ATTRIBUTE, this.getAutocomplete());
        tagWriter.endTag();
        return 0;
    }

    protected void writeValue(TagWriter tagWriter) throws JspException {
        String value = this.getDisplayString(this.getBoundValue(), this.getPropertyEditor());
        String type = null;
        Map<String, Object> attributes = this.getDynamicAttributes();
        if (attributes != null) {
            type = (String)attributes.get("type");
        }
        if (type == null) {
            type = this.getType();
        }
        tagWriter.writeAttribute("value", this.processFieldValue(this.getName(), value, type));
    }

    @Override
    protected boolean isValidDynamicAttribute(String localName, Object value) {
        return !"type".equals(localName) || !"checkbox".equals(value) && !"radio".equals(value);
    }

    protected String getType() {
        return "text";
    }
}

