/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;

class DefaultResourceResolverChain
implements ResourceResolverChain {
    private final List<ResourceResolver> resolvers = new ArrayList<ResourceResolver>();
    private int index = -1;

    public DefaultResourceResolverChain(@Nullable List<? extends ResourceResolver> resolvers) {
        if (resolvers != null) {
            this.resolvers.addAll(resolvers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Resource resolveResource(@Nullable HttpServletRequest request, String requestPath, List<? extends Resource> locations) {
        ResourceResolver resolver = this.getNext();
        if (resolver == null) {
            return null;
        }
        try {
            Resource resource = resolver.resolveResource(request, requestPath, locations, this);
            return resource;
        }
        finally {
            --this.index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String resolveUrlPath(String resourcePath, List<? extends Resource> locations) {
        ResourceResolver resolver = this.getNext();
        if (resolver == null) {
            return null;
        }
        try {
            String string = resolver.resolveUrlPath(resourcePath, locations, this);
            return string;
        }
        finally {
            --this.index;
        }
    }

    @Nullable
    private ResourceResolver getNext() {
        Assert.state((this.index <= this.resolvers.size() ? 1 : 0) != 0, (String)"Current index exceeds the number of configured ResourceResolvers");
        if (this.index == this.resolvers.size() - 1) {
            return null;
        }
        ++this.index;
        return this.resolvers.get(this.index);
    }
}

