/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.support.RequestContextUtils;

public class ParameterizableViewController
extends AbstractController {
    @Nullable
    private Object view;
    @Nullable
    private HttpStatus statusCode;
    private boolean statusOnly;

    public ParameterizableViewController() {
        super(false);
        this.setSupportedMethods(HttpMethod.GET.name(), HttpMethod.HEAD.name());
    }

    public void setViewName(@Nullable String viewName) {
        this.view = viewName;
    }

    @Nullable
    public String getViewName() {
        return this.view instanceof String ? (String)this.view : null;
    }

    public void setView(View view) {
        this.view = view;
    }

    @Nullable
    public View getView() {
        return this.view instanceof View ? (View)this.view : null;
    }

    public void setStatusCode(@Nullable HttpStatus statusCode) {
        this.statusCode = statusCode;
    }

    @Nullable
    public HttpStatus getStatusCode() {
        return this.statusCode;
    }

    public void setStatusOnly(boolean statusOnly) {
        this.statusOnly = statusOnly;
    }

    public boolean isStatusOnly() {
        return this.statusOnly;
    }

    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String viewName = this.getViewName();
        if (this.getStatusCode() != null) {
            if (this.getStatusCode().is3xxRedirection()) {
                request.setAttribute(View.RESPONSE_STATUS_ATTRIBUTE, (Object)this.getStatusCode());
                viewName = viewName != null && !viewName.startsWith("redirect:") ? "redirect:" + viewName : viewName;
            } else {
                response.setStatus(this.getStatusCode().value());
                if (this.isStatusOnly() || this.getStatusCode().equals((Object)HttpStatus.NO_CONTENT) && this.getViewName() == null) {
                    return null;
                }
            }
        }
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.addAllObjects(RequestContextUtils.getInputFlashMap(request));
        if (this.getViewName() != null) {
            modelAndView.setViewName(viewName);
        } else {
            modelAndView.setView(this.getView());
        }
        return this.isStatusOnly() ? null : modelAndView;
    }
}

