/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.upgrade;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.api.Configurable;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.exceptions.WebSocketException;
import org.eclipse.jetty.websocket.server.ServerWebSocketContainer;
import org.eclipse.jetty.websocket.server.WebSocketCreator;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.ContextWebSocketHandler;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketSession;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class JettyCoreRequestUpgradeStrategy
implements RequestUpgradeStrategy {
    private @Nullable Consumer<Configurable> webSocketConfigurer;
    private @Nullable ServerWebSocketContainer serverContainer;

    public void addWebSocketConfigurer(Consumer<Configurable> webSocketConfigurer) {
        this.webSocketConfigurer = this.webSocketConfigurer != null ? this.webSocketConfigurer.andThen(webSocketConfigurer) : webSocketConfigurer;
    }

    @Override
    public Mono<Void> upgrade(ServerWebExchange exchange2, WebSocketHandler handler, @Nullable String subProtocol, Supplier<HandshakeInfo> handshakeInfoFactory) {
        ServerHttpRequest request = exchange2.getRequest();
        ServerHttpResponse response = exchange2.getResponse();
        Request jettyRequest = (Request)ServerHttpRequestDecorator.getNativeRequest((ServerHttpRequest)request);
        Response jettyResponse = (Response)ServerHttpResponseDecorator.getNativeResponse((ServerHttpResponse)response);
        HandshakeInfo handshakeInfo = handshakeInfoFactory.get();
        DataBufferFactory factory = response.bufferFactory();
        return exchange2.getResponse().setComplete().then(Mono.deferContextual(contextView -> {
            JettyWebSocketHandlerAdapter adapter = new JettyWebSocketHandlerAdapter(ContextWebSocketHandler.decorate(handler, contextView), session -> new JettyWebSocketSession((Session)session, handshakeInfo, factory));
            WebSocketCreator webSocketCreator = (upgradeRequest, upgradeResponse, callback) -> {
                if (subProtocol != null) {
                    upgradeResponse.setAcceptedSubProtocol(subProtocol);
                }
                return adapter;
            };
            Callback.Completable callback2 = new Callback.Completable();
            Mono mono = Mono.fromFuture((CompletableFuture)callback2);
            ServerWebSocketContainer container = this.getWebSocketServerContainer(jettyRequest);
            try {
                if (!container.upgrade(webSocketCreator, jettyRequest, jettyResponse, (Callback)callback2)) {
                    throw new WebSocketException("request could not be upgraded to websocket");
                }
            }
            catch (WebSocketException ex) {
                callback2.failed((Throwable)ex);
            }
            return mono;
        }));
    }

    private ServerWebSocketContainer getWebSocketServerContainer(Request jettyRequest) {
        if (this.serverContainer == null) {
            Server server = jettyRequest.getConnectionMetaData().getConnector().getServer();
            ServerWebSocketContainer container = ServerWebSocketContainer.get((Context)server.getContext());
            if (this.webSocketConfigurer != null) {
                this.webSocketConfigurer.accept((Configurable)container);
            }
            this.serverContainer = container;
        }
        return this.serverContainer;
    }
}

