/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.reactive.result.view.Fragment;
import org.springframework.web.reactive.result.view.FragmentsRendering;
import reactor.core.publisher.Flux;

class DefaultFragmentsRenderingBuilder
implements FragmentsRendering.Builder {
    private @Nullable Collection<Fragment> fragmentsCollection;
    private final @Nullable Flux<Fragment> fragmentsFlux;
    private @Nullable HttpStatusCode status;
    private @Nullable HttpHeaders headers;

    DefaultFragmentsRenderingBuilder() {
        this.fragmentsCollection = null;
        this.fragmentsFlux = null;
    }

    DefaultFragmentsRenderingBuilder(Publisher<Fragment> fragments) {
        this.fragmentsFlux = Flux.from(fragments);
    }

    @Override
    public FragmentsRendering.Builder status(HttpStatusCode status) {
        this.status = status;
        return this;
    }

    @Override
    public FragmentsRendering.Builder header(String headerName, String ... headerValues) {
        this.initHeaders().put(headerName, Arrays.asList(headerValues));
        return this;
    }

    @Override
    public FragmentsRendering.Builder headers(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.initHeaders());
        return this;
    }

    private HttpHeaders initHeaders() {
        if (this.headers == null) {
            this.headers = new HttpHeaders();
        }
        return this.headers;
    }

    @Override
    public FragmentsRendering.Builder fragment(String viewName) {
        return this.fragment(Fragment.create(viewName));
    }

    @Override
    public FragmentsRendering.Builder fragment(String viewName, Map<String, Object> model) {
        return this.fragment(Fragment.create(viewName, model));
    }

    @Override
    public FragmentsRendering.Builder fragment(Fragment fragment) {
        this.initFragmentsCollection().add(fragment);
        return this;
    }

    @Override
    public FragmentsRendering.Builder fragments(Collection<Fragment> fragments) {
        this.initFragmentsCollection().addAll(fragments);
        return this;
    }

    private Collection<Fragment> initFragmentsCollection() {
        if (this.fragmentsCollection == null) {
            this.fragmentsCollection = new ArrayList<Fragment>();
        }
        return this.fragmentsCollection;
    }

    @Override
    public FragmentsRendering build() {
        return new DefaultFragmentsRendering(this.status, this.headers != null ? this.headers : HttpHeaders.EMPTY, this.getFragmentsFlux());
    }

    private Flux<Fragment> getFragmentsFlux() {
        if (this.fragmentsFlux != null && this.fragmentsCollection != null) {
            return this.fragmentsFlux.concatWith((Publisher)Flux.fromIterable(this.fragmentsCollection));
        }
        if (this.fragmentsFlux != null) {
            return this.fragmentsFlux;
        }
        if (this.fragmentsCollection != null) {
            return Flux.fromIterable(this.fragmentsCollection);
        }
        return Flux.empty();
    }

    private record DefaultFragmentsRendering(@Nullable HttpStatusCode status, HttpHeaders headers, Flux<Fragment> fragments) implements FragmentsRendering
    {
    }
}

