/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.web.accept.MissingApiVersionException;
import org.springframework.web.accept.SemanticApiVersionParser;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;

public class ApiVersionMethodArgumentResolver
implements SyncHandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return SemanticApiVersionParser.Version.class == parameter.nestedIfOptional().getNestedParameterType();
    }

    @Override
    public @Nullable Object resolveArgumentValue(MethodParameter parameter, BindingContext bindingContext, ServerWebExchange exchange2) {
        Object version = exchange2.getAttribute(HandlerMapping.API_VERSION_ATTRIBUTE);
        if (parameter.getParameterType() == Optional.class) {
            return Optional.ofNullable(version);
        }
        if (version == null) {
            if (!parameter.isOptional()) {
                throw new MissingApiVersionException();
            }
            return null;
        }
        if (version instanceof SemanticApiVersionParser.Version) {
            SemanticApiVersionParser.Version semanticApiVersion = (SemanticApiVersionParser.Version)version;
            return semanticApiVersion;
        }
        throw new IllegalStateException("Unexpected version type: " + String.valueOf(version.getClass()));
    }
}

