/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseCookie;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.server.DefaultRenderingResponseBuilder;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

public interface RenderingResponse
extends ServerResponse {
    public String name();

    public Map<String, Object> model();

    public static Builder from(RenderingResponse other) {
        return new DefaultRenderingResponseBuilder(other);
    }

    public static Builder create(String name) {
        return new DefaultRenderingResponseBuilder(name);
    }

    public static interface Builder {
        public Builder modelAttribute(Object var1);

        public Builder modelAttribute(String var1, @Nullable Object var2);

        public Builder modelAttributes(Object ... var1);

        public Builder modelAttributes(Collection<?> var1);

        public Builder modelAttributes(Map<String, ?> var1);

        public Builder header(String var1, String ... var2);

        public Builder headers(HttpHeaders var1);

        public Builder status(HttpStatusCode var1);

        public Builder status(int var1);

        public Builder cookie(ResponseCookie var1);

        public Builder cookies(Consumer<MultiValueMap<String, ResponseCookie>> var1);

        public Mono<RenderingResponse> build();
    }
}

