/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import reactor.core.publisher.Mono;

public abstract class ExchangeFilterFunctions {
    public static ExchangeFilterFunction limitResponseSize(long maxByteCount) {
        return (request, next) -> next.exchange(request).map(response -> response.mutate().body(body2 -> DataBufferUtils.takeUntilByteCount((Publisher)body2, (long)maxByteCount)).build());
    }

    public static ExchangeFilterFunction statusError(Predicate<HttpStatusCode> statusPredicate, Function<ClientResponse, ? extends Throwable> exceptionFunction) {
        Assert.notNull(statusPredicate, (String)"Predicate must not be null");
        Assert.notNull(exceptionFunction, (String)"Function must not be null");
        return ExchangeFilterFunction.ofResponseProcessor(response -> statusPredicate.test(response.statusCode()) ? Mono.error((Throwable)((Throwable)exceptionFunction.apply((ClientResponse)response))) : Mono.just((Object)response));
    }

    public static ExchangeFilterFunction basicAuthentication(String username, String password) {
        String encodedCredentials = HttpHeaders.encodeBasicAuth((String)username, (String)password, null);
        return (request, next) -> next.exchange(ClientRequest.from(request).headers(headers -> headers.setBasicAuth(encodedCredentials)).build());
    }
}

